#!/usr/bin/env bash

set -e

THIS_DIR="$(dirname "$(readlink -f "$0")")"
LIB_DIR="$THIS_DIR/lib"

export LD_LIBRARY_PATH="$LIB_DIR"${LD_LIBRARY_PATH:+:$LD_LIBRARY_PATH}
export QT_QPA_PLATFORM_PLUGIN_PATH="$THIS_DIR/bin/qt5_plugins"

if ! which wish  >/dev/null 2>/dev/null ; then
    if ! which wish8.5  >/dev/null 2>/dev/null ; then
        if ! which wish8.6  >/dev/null 2>/dev/null ; then
            echo "Missing dependency: 'tcl/tk'."
            echo "On Linux distributions using 'yum', such as Fedora, tcl/tk can be installed by running 'sudo yum install tk'."
            echo "On Linux distributions using 'apt', such as Ubuntu, tcl/tk can be installed by running 'sudo apt-get install tk'."
            exit -1
        fi
    fi
fi

if LD_LIBRARY_PATH="$LD_LIBRARY_PATH" ldd -r "$THIS_DIR"/bin/radium_linux.bin |grep libglib-2 |grep not\ found ; then
    echo 
    echo "Missing dependency: 'glib-2'."
    echo "On Linux distributions using 'yum', such as Fedora, glib-2 can be installed by running 'sudo yum install glib2'."
    echo "On Linux distributions using 'apt', such as Ubuntu, glib-2 can be installed by running 'sudo apt-get install libglib2.0'."
    exit -1
fi

LD_LIBRARY_PATH="$LD_LIBRARY_PATH" QT_QPA_PLATFORM_PLUGIN_PATH="$QT_QPA_PLATFORM_PLUGIN_PATH" "$THIS_DIR"/bin/radium "$@"
