(provide 'api_protos.scm)
(define ra:api-protos '(
  (void ra:init_radium (const_char* arg ) (PyObject* gkf ) )
  (void ra:key-down-play (int notenum ) (int windownum -1) )
  (void ra:poly-key-down-play (int notenum ) (int windownum -1) )
  (void ra:key-up-play (int notenum ) (int windownum -1) )
  (void ra:set-key-add (int addnum ) )
  (void ra:inc-key-add (int incaddnum ) )
  (void ra:dec-key-add (int decaddnum ) )
  (bool ra:switch-drunk-velocity-on-off )
  (void ra:switch-edit-on-off )
  (void ra:switch-sound-scroll-on-off (int windownum -1) )
  (void ra:inc-note-volume (int incvolume ) (int windownum -1) )
  (bool ra:do-scroll-play )
  (void ra:set-scroll-play (bool doit ) )
  (void ra:switch-scroll-play-on-off )
  (bool ra:do-auto-repeat )
  (void ra:set-auto-repeat (bool doit ) )
  (bool ra:do-range-paste-cut )
  (void ra:set-range-paste-cut (bool doit ) )
  (bool ra:do-range-paste-scroll-down )
  (void ra:set-range-paste-scroll-down (bool doit ) )
  (bool ra:do-scroll-edit-lines )
  (void ra:set-scroll-edit-lines (bool doit ) )
  (void ra:set-note-scroll-length (int length ) )
  (int ra:get-note-scroll-length )
  (void ra:cursor-down (int numlines ) (int windownum -1) )
  (void ra:cursor-up (int numlines ) (int windownum -1) )
  (void ra:cursor-next-note (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-prev-note (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-next-waveform (int polyphony_num -1) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-prev-waveform (int polyphony_num -1) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-next-velocity (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-prev-velocity (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-next-fx (int fxnum -1) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-prev-fx (int fxnum -1) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-next-something (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-prev-something (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-curr-realline (int blocknum -1) (int windownum -1) )
  (void ra:set-curr-realline (int realline ) (int blocknum -1) (int windownum -1) )
  (void ra:cursor-user-input-line )
  (void ra:request-cursor-move )
  (void ra:cursor-percent-line (int percent ) (int windownum -1) )
  (void ra:select-next-block (int windownum -1) )
  (void ra:select-prev-block (int windownum -1) )
  (void ra:select-next-playlist-block )
  (void ra:select-prev-playlist-block )
  (void ra:select-track (int tracknum ) (int windownum -1) )
  (void ra:set-current-track (int tracknum ) (int subtrack -2) (int windownum -1) (bool switch_instrument_even_if_locked true) )
  (int ra:get-current-track (int windownum -1) )
  (int ra:get-current-subtrack (int windownum -1) )
  (int ra:get-num-subtracks (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:get-track-visible (int tracknum ) (int blocknum -1) (int windownum -1) )
  (bool ra:can-cursor-move-to-track (int tracknum ) (int subtrack -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-leftmost-cursor-track (int blocknum -1) (int windownum -1) )
  (void ra:cursor-right (int windownum -1) (bool switch_instrument_even_if_locked true) )
  (void ra:cursor-next-track (int windownum -1) (bool switch_instrument_even_if_locked true) )
  (void ra:cursor-left (int windownum -1) (bool switch_instrument_even_if_locked true) )
  (void ra:cursor-prev-track (int windownum -1) (bool switch_instrument_even_if_locked true) )
  (int ra:current-block (int windownum -1) )
  (int ra:current-track (int blocknum -1) (int windownum -1) )
  (int ra:current-line (int blocknum -1) (int windownum -1) )
  (void ra:set-current-line (int linenum ) (int windownum -1) )
  (void ra:all-tracks-on )
  (bool ra:track-on (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-on (bool is_on ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:switch-track-on (int tracknum -1) (int windownum -1) )
  (void ra:solo-track (int tracknum -1) (int windownum -1) )
  (void ra:switch-solo-track (int tracknum -1) (int windownum -1) )
  (void ra:expand-block (int blocknum -1) )
  (void ra:expand-range (int blocknum -1) (int windownum -1) )
  (void ra:line-zoom-block (int numlines ) (int blocknum -1) (int windownum -1) )
  (int ra:get-line-zoom-block (int blocknum -1) (int windownum -1) )
  (dyn_t ra:get-line-zoom-block-ratio (int blocknum -1) (int windownum -1) )
  (void ra:expand-line (int numlines ) (int windownum -1) )
  (void ra:split-line (int numlines ) (int windownum -1) )
  (void ra:unsplit-line (int windownum -1) )
  (void ra:zoom (int incfontsize ) (int windownum -1) )
  (void ra:reset-editor-zoom (int windownum -1) )
  (void ra:reset-mixer-zoom )
  (void ra:reset-sequencer-zoom )
  (void ra:unzoom (int windownum -1) )
  (void ra:transpose-track (int transpose ) (int windownum -1) )
  (void ra:transpose-block (int transpose ) (int windownum -1) )
  (void ra:transpose-range (int transpose ) (int windownum -1) )
  (void ra:transpose-note (int transpose ) (int windownum -1) )
  (void ra:invert-track (int windownum -1) )
  (void ra:invert-block (int windownum -1) )
  (void ra:invert-range (int windownum -1) )
  (void ra:pexpand-track (int f -1000) (int windownum -1) )
  (void ra:pexpand-block (int f -1000) (int windownum -1) )
  (void ra:pexpand-range (int f -1000) (int windownum -1) )
  (void ra:backwards-track (int windownum -1) )
  (void ra:backwards-block (int windownum -1) )
  (void ra:backwards-song )
  (void ra:backwards-range (int windownum -1) )
  (void ra:general-track-quantitize (int windownum -1) )
  (void ra:quantitize-track (int windownum -1) )
  (void ra:quantitize-block (int windownum -1) )
  (void ra:quantitize-range (int windownum -1) )
  (dyn_t ra:get-quantitize (bool as_string false) )
  (void ra:set-quantitize (dyn_t ratio ) )
  (int ra:get-quantitize-type )
  (void ra:set-quantitize-type (int type ) )
  (void ra:config-quantitize (int windownum -1) )
  (Place ra:get-grid )
  (void ra:glissando (int windownum -1) )
  (const_char* ra:get-note-name2 (int notenum -1) )
  (const_char* ra:get-note-name3 (int notenum -1) )
  (float ra:get-note-name-value (const_char* notename ) )
  (float ra:get-lowest-key (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-highest-key (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-pianoroll-low-key (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-pianoroll-high-key (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-pianoroll-range (int minkey ) (int maxkey ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-pianoroll-low-key (int key ) (int tracknum ) (int blocknum -1) (int windownum -1) )
  (void ra:set-pianoroll-high-key (int key ) (int tracknum ) (int blocknum -1) (int windownum -1) )
  (void ra:set-pianoroll-auto-range (int tracknum ) (int blocknum -1) (int windownum -1) )
  (int ra:get-note-volume (int windownum -1) (int blocknum -1) (int tracknum -1) (dyn_t note g_dyn_minus_one) )
  (int ra:get-num-notes (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-note (float notevalue ) (float velocity ) (Place start ) (Place end ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-note3 (float notevalue ) (float velocity ) (int start_line ) (int start_counter ) (int start_dividor ) (int end_line ) (int end_counter ) (int end_dividor ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:cut-note (Place place ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-note (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:note-continues-next-block (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-note-continue-next-block (bool continuenextblock ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-all-notes-in-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-all-notes-and-stops-in-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-all-stops-in-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:undo-notes (int tracknum -1) (int blocknum -1) )
  (const_char* ra:get-note-id (int notenum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-note-num (dyn_t noteid ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (Place ra:get-note-start (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (Place ra:get-note-end (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-note-value (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-note-end-pitch (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-note-subtrack (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-no-mouse-note (int blocknum -1) (int windownum -1) )
  (void ra:set-mouse-note (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:update-notes-in-player )
  (dynvec_t ra:get-all-notes (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:unselect-all-notes (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:note-is-selected (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:select-note (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:unselect-note (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (dynvec_t ra:get-selected-notes (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:has-selected-notes (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-velocity-x (int num ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-velocity-y (int num ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-velocity-value (int num ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (Place ra:get-velocity-place (int num ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-velocity-logtype (int num ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-num-velocities (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-velocity (float value ) (Place place ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-velocity-dont-display-errors (float value ) (Place place ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-velocity-f (float value ) (float floatplace ) (int notnum -1) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:set-velocity (float value ) (Place place ) (int velocitynum ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:set-velocity-f (float value ) (float floatplace ) (int velocitynum ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-velocity (int velocitynum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-velocity-logtype (int logtype ) (int velocitynum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-current-velocity-node (int velocitynum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-indicator-velocity-node (int velocitynum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitch-value (int num ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (Place ra:get-pitch-place (int num ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-pitch-logtype (int num ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitch-chance (int num ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-num-pitches (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-pitch (float value ) (Place place ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-pitch-f (float value ) (float floatplace ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:set-pitch (float value ) (Place place ) (int pitchnum ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:set-pitch-f (float value ) (float floatplace ) (int pitchnum ) (dyn_t note g_dyn_minus_one) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-pitch (int pitchnum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-pitch-logtype (int logtype ) (int pitchnum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-main-signature (int numerator ) (int denominator ) )
  (void ra:set-main-lpb (int lpb ) )
  (void ra:set-main-bpm (int bpm ) )
  (Place ra:get-main-signature )
  (int ra:get-main-lpb )
  (int ra:get-main-bpm )
  (int ra:num-signatures (int blocknum -1) (int windownum -1) )
  (int ra:add-signature (int numerator ) (int denominator ) (Place place ) (int blocknum -1) )
  (int ra:add-signature3 (int numerator ) (int denominator ) (int line ) (int counter ) (int dividor ) (int blocknum -1) )
  (Place ra:get-signature (int signaturenum ) (int blocknum -1) (int windownum -1) )
  (int ra:num-lpbs (int blocknum -1) (int windownum -1) )
  (int ra:add-lpb (int lpb ) (Place place ) (int blocknum -1) )
  (int ra:add-lpb3 (int lpb ) (int line ) (int counter ) (int dividor ) (int blocknum -1) )
  (int ra:get-lpb (int num ) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:get-all-lpb (int blocknum -1) (int windownum -1) )
  (int ra:num-bpms (int blocknum -1) (int windownum -1) )
  (void ra:set-bpms (dynvec_t bpms ) (int blocknum -1) )
  (int ra:add-bpm (int bpm ) (Place place ) (int blocknum -1) )
  (int ra:add-bpm3 (int bpm ) (int line ) (int counter ) (int dividor ) (int blocknum -1) )
  (int ra:get-bpm (int num ) (int blocknum -1) (int windownum -1) )
  (Place ra:get-bpm-place (int num ) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:get-all-bpm (int blocknum -1) (int windownum -1) )
  (int ra:get-num-temponodes (int blocknum -1) (int windownum -1) )
  (void ra:undo-temponodes )
  (void ra:set-temponode (int num ) (double value ) (Place place ) (int blocknum -1) (int windownum -1) )
  (void ra:delete-temponode (int num ) (int blocknum -1) )
  (int ra:add-temponode (float value ) (Place place ) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:get-all-temponodes (int blocknum -1) (int windownum -1) )
  (dyn_t ra:get-all-beats (int blocknum -1) (int windownum -1) )
  (dyn_t ra:get-all-block-swings (int blocknum -1) (int windownum -1) )
  (dyn_t ra:get-track-swings (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-swings (dynvec_t swings ) (int tracknum -1) (int blocknum -1) )
  (void ra:play-block-from-start (int windownum -1) )
  (void ra:play-block-from-current (int windownum -1) )
  (void ra:play-song-from-start )
  (void ra:play-song-from-current (int windownum -1) )
  (void ra:play-song-from-current-sequencer-position )
  (void ra:play-range-from-start (int windownum -1) )
  (void ra:play-range-from-current (int windownum -1) )
  (void ra:set-song-pos (int64_t pos ) )
  (int64_t ra:get-song-pos )
  (void ra:inc-song-pos (double inc ) )
  (int64_t ra:get-last-song-pos-start )
  (void ra:set-last-song-pos-start (int64_t pos ) )
  (void ra:play-song-from-pos (int64_t pos ) )
  (void ra:play-stop )
  (void ra:volume-up )
  (void ra:volume-down )
  (void ra:mute )
  (bool ra:is-playing )
  (bool ra:is-playing-block )
  (bool ra:is-playing-song )
  (double ra:line-duration (int line ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:clear-range (int windownum -1) )
  (void ra:clear-range2 (Place p1 ) (Place p2 ) (int start_track ) (int end_track ) (int blocknum -1) (int windownum -1) )
  (void ra:cut-range (int rangetype 0) (int windownum -1) )
  (void ra:cut-range2 (Place p1 ) (Place p2 ) (int start_track ) (int end_track ) (int rangetype 0) (int blocknum -1) (int windownum -1) )
  (void ra:copy-range (int rangetype 0) (int windownum -1) )
  (void ra:copy-range2 (Place p1 ) (Place p2 ) (int start_track ) (int end_track ) (int rangetype 0) (int blocknum -1) (int windownum -1) )
  (void ra:paste-range (int rangetype 0) (int windownum -1) )
  (void ra:paste-range2 (Place startplace ) (int starttracknum ) (int rangetype 0) (int blocknum -1) (int windownum -1) )
  (void ra:mark-range (int windownum -1) )
  (void ra:cancel-range (int windownum -1) )
  (void ra:cut-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:clear-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:copy-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:paste-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:copy-block (int windownum -1) )
  (void ra:paste-block (int windownum -1) )
  (void ra:cut-general )
  (void ra:copy-general )
  (void ra:paste-general )
  (void ra:copy-selected-mixer-objects )
  (void ra:delete-selected-mixer-objects )
  (void ra:cut-selected-mixer-objects )
  (instrument_t ra:paste-mixer-objects (float x -10000) (float y -10000) )
  (int ra:get-num-tracks-in-range (int rangetype 0) )
  (Place ra:get-range-length (int rangetype 0) )
  (bool ra:has-range-in-clipboard (int rangetype 0) )
  (bool ra:has-range (int blocknum -1) (int windownum -1) )
  (int ra:get-range-start-track (int blocknum -1) (int windownum -1) )
  (int ra:get-range-end-track (int blocknum -1) (int windownum -1) )
  (Place ra:get-range-start-place (int blocknum -1) (int windownum -1) )
  (Place ra:get-range-end-place (int blocknum -1) (int windownum -1) )
  (void ra:set-range (Place p1 ) (Place p2 ) (int start_track ) (int end_track ) (int blocknum -1) (int windownum -1) )
  (void ra:save-block (filepath_t filename createIllegalFilepath()) (int blocknum -1) (int windownum -1) )
  (void ra:load-block (filepath_t filename createIllegalFilepath()) )
  (void ra:save-track (filepath_t filename createIllegalFilepath()) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:load-track (filepath_t filename createIllegalFilepath()) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-max-undos (int windownum -1) )
  (const_char* ra:get-undo-history )
  (void ra:redo )
  (void ra:undo )
  (void ra:reset-undo )
  (void ra:start-ignoring-undo )
  (void ra:stop-ignoring-undo )
  (void ra:cancel-last-undo )
  (void ra:add-undo-block (int blocknum -1) )
  (void ra:add-undo-track )
  (bool ra:ask-are-you-sure-song-has-changed )
  (void ra:open-undo )
  (void ra:close-undo )
  (void ra:add-undo-redo-callback (func_t* callback ) )
  (void ra:remove-undo-redo-callback (func_t* callback ) )
  (void ra:add-dirty-status-change-callback (func_t* callback ) )
  (void ra:remove-dirty-status-change-callback (func_t* callback ) )
  (void ra:editor-window-to-front (int windownum -1) )
  (void ra:play-list-window-to-front )
  (void ra:instrument-window-to-front )
  (void ra:set-mixer-rotate (float rotate ) )
  (bool ra:main-mixer-is-modular )
  (void ra:set-main-mixer-is-modular (bool show_modular ) )
  (void ra:switch-main-mixer-is-modular )
  (void ra:set-main-mixer-in-window (bool show_window ) )
  (bool ra:main-mixer-in-window )
  (bool ra:switch-main-mixer-in-window )
  (void ra:set-show-cpu-usage-in-mixer (bool showit ) )
  (bool ra:get-show-cpu-usage-in-mixer )
  (bool ra:switch-show-cpu-usage-in-mixer )
  (void ra:set-visible-mixer-connections (bool val ) )
  (bool ra:get-visible-mixer-connections )
  (bool ra:switch-visible-mixer-connections )
  (void ra:set-visible-mixer-bus-connections (bool val ) )
  (bool ra:get-visible-mixer-bus-connections )
  (bool ra:switch-visible-mixer-bus-connections )
  (bool ra:show-instrument-widget-when-double-clicking-sound-object )
  (void ra:set-show-instrument-widget-when-double-clicking-sound-object (bool val ) )
  (bool ra:show-playlist-during-startup )
  (void ra:set-show-playlist-during-startup (bool val ) )
  (bool ra:show-mixer-strip-during-startup )
  (void ra:set-show-mixer-strip-during-startup (bool val ) )
  (bool ra:instrument-in-mixer )
  (void ra:set-instrument-in-mixer (bool val ) )
  (bool ra:switch-instrument-in-mixer )
  (bool ra:sequencer-in-mixer )
  (void ra:set-sequencer-in-mixer (bool val ) )
  (bool ra:switch-sequencer-in-mixer )
  (bool ra:sequencer-in-main-tabs )
  (void ra:delete-pd-controller (instrument_t instrument_id ) (const_char* effect_name ) )
  (bool ra:instrument-always-receive-midi-input (instrument_t instrument_id ) )
  (void ra:set-instrument-always-receive-midi-input (instrument_t instrument_id ) (bool always_receive_midi_input ) )
  (void ra:switch-set-instrument-always-receive-midi-input (instrument_t instrument_id getCurrentInstrumentUnderMouse()) )
  (bool ra:get-note-duplicator-set-new-value-immediately (instrument_t instrument_id ) (const_char* effect_name ) )
  (void ra:set-note-duplicator-set-new-value-immediately (instrument_t instrument_id ) (const_char* effect_name ) (bool set_immediately ) )
  (bool ra:show-mixer-strip-on-left-side )
  (void ra:set-show-mixer-strip-on-left-side (bool val ) )
  (bool ra:sequencer-window-is-child-of-main-window )
  (void ra:set-sequencer-window-is-child-of-main-window (bool val ) )
  (bool ra:mixer-window-is-child-of-main-window )
  (void ra:set-mixer-window-is-child-of-main-window (bool val ) )
  (bool ra:help-window-is-child-of-main-window )
  (void ra:set-help-window-is-child-of-main-window (bool val ) )
  (bool ra:swap-ctrl-and-cmd )
  (void ra:set-swap-ctrl-and-cmd (bool val ) )
  (void ra:toggle-curr-window-full-screen )
  (void ra:toggle-full-screen (int windownum -1) )
  (bool ra:editor-is-visible (int windownum -1) )
  (void ra:show-editor )
  (void ra:hide-editor )
  (void ra:show-hide-editor (int windownum -1) )
  (void ra:show-hide-focus-editor )
  (void ra:show-hide-preset-browser )
  (void ra:delete-preset-browser-instrument )
  (void ra:set-editor-keyboard-focus (bool setit true) )
  (void ra:set-mixer-keyboard-focus (bool setit true) )
  (void ra:set-sequencer-keyboard-focus (bool setit true) )
  (void ra:set-best-guess-keyboard-focus )
  (bool ra:editor-has-keyboard-focus )
  (bool ra:mixer-has-keyboard-focus )
  (bool ra:sequencer-has-keyboard-focus )
  (void ra:show-sequencer )
  (void ra:hide-sequencer )
  (bool ra:sequencer-is-visible )
  (void ra:show-hide-sequencer )
  (void ra:show-hide-focus-sequencer )
  (void ra:configure-sequencer-widget (bool in_window ) (bool in_main_tabs sequencerInMainTabs()) )
  (void ra:set-sequencer-in-window (bool doit ) )
  (bool ra:sequencer-in-window )
  (void ra:show-hide-sequencer-in-window )
  (void ra:set-sequencer-in-full-mode (bool doit ) )
  (bool ra:sequencer-in-full-mode )
  (bool ra:switch-sequencer-in-full-mode )
  (void ra:switch-sequencer-playlist-configuration )
  (void ra:show-hide-mixer-widget )
  (bool ra:mixer-is-visible )
  (void ra:show-hide-focus-mixer )
  (void ra:show-hide-instrument-widget (int windownum -1) )
  (void ra:show-hide-playlist (int windownum -1) )
  (void ra:show-hide-mixer-strip (int windownum -1) )
  (void ra:show-hide-edit-widget )
  (void ra:show-edit-gui )
  (void ra:hide-edit-gui )
  (bool ra:edit-gui-is-visible )
  (void ra:show-edit-quantitize-tab )
  (void ra:show-edit-transpose-tab )
  (void ra:show-edit-randomize-tab )
  (void ra:show-edit-various-tab )
  (void ra:hide-upper-part-of-main-window )
  (void ra:show-upper-part-of-main-window )
  (bool ra:upper-part-of-main-window-is-visible )
  (void ra:show-hide-upper-part-of-main-window )
  (int ra:get-max-submenu-entries )
  (void ra:set-max-submenu-entries (int val ) )
  (float ra:get-tab-bar-height )
  (void ra:set-tab-bar-height (float new_val ) )
  (void ra:show-hide-menu-bar (int windownum -1) )
  (void ra:hide-menu-bar (int windownum -1) )
  (void ra:show-menu-bar (int windownum -1) )
  (void ra:switch-window-configuration )
  (void ra:enable-metronome (bool onoff ) )
  (bool ra:metronome-enabled )
  (bool ra:switch-metronome )
  (bool ra:play-cursor-enabled )
  (void ra:enable-play-cursor (bool onoff ) )
  (void ra:switch-play-cursor-on-off )
  (bool ra:editor-follows-play-cursor )
  (void ra:enable-editor-follows-play-cursor (bool onoff ) )
  (bool ra:switch-editor-follows-play-cursor )
  (bool ra:allow-automatically-changing-current-block )
  (void ra:set-allow-automatically-changing-current-block (bool allow ) )
  (bool ra:switch-allow-automatically-changing-current-block )
  (bool ra:autoselect-editor-block-under-mouse )
  (void ra:set-autoselect-editor-block-under-mouse (bool val ) )
  (bool ra:autoselect-editor-block-when-changing-seqtrack )
  (void ra:set-autoselect-editor-block-when-changing-seqtrack (bool val ) )
  (bool ra:autoselect-seqtrack-under-mouse )
  (void ra:set-autoselect-seqtrack-under-mouse (bool val ) )
  (bool ra:sequencer-mouse-scroll-wheel-starts-stops-playing )
  (void ra:set-sequencer-mouse-scroll-wheel-starts-stops-playing (bool val ) )
  (void ra:insert-reallines (int toinsert ) (int windownum -1) )
  (void ra:general-transpose-entry-down (bool big_step false) )
  (void ra:general-transpose-entry-up (bool big_step false) )
  (void ra:general-transpose-track-down (bool big_step false) )
  (void ra:general-transpose-track-up (bool big_step false) )
  (void ra:general-transpose-range-down (bool big_step false) )
  (void ra:general-transpose-range-up (bool big_step false) )
  (void ra:general-transpose-block-down (bool big_step false) )
  (void ra:general-transpose-block-up (bool big_step false) )
  (void ra:general-delete (bool scroll_down true) (int windownum -1) )
  (void ra:simulate-delete-mouse-button )
  (void ra:insert-lines (int toinsert 0) (int windownum -1) )
  (void ra:insert-lines2 (Place start ) (Place how_much ) (int blocknum -1) )
  (void ra:delete-lines2 (Place start ) (Place end ) (int blocknum -1) )
  (void ra:general-return (int windownum -1) )
  (int ra:append-block )
  (void ra:append-track (int blocknum -1) )
  (void ra:swap-tracks (int windownum -1) )
  (void ra:make-track-monophonic (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:split-track-into-monophonic-tracks (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:split-block (int windownum -1) )
  (void ra:set-num-tracks (int numtracks ) (int blocknum -1) (int windownum -1) )
  (void ra:set-num-lines (int numlines ) (int blocknum -1) (int windownum -1) )
  (const_char* ra:get-track-type-name (int tracknum ) )
  (void ra:change-track-note-length (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-note-length (int notelength ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-track-note-length (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:change-block-note-length (int windownum -1) )
  (void ra:change-track-note-area-width (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:track-note-area-width-is-wide (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-note-area-width (bool is_wide ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:change-block-note-area-width (int windownum -1) )
  (void ra:minimize-track (int windownum -1) (int blocknum -1) (int tracknum -1) )
  (void ra:minimize-block-tracks (int windownum -1) (int blocknum -1) (bool force true) )
  (void ra:quit )
  (void ra:save-soundfile )
  (void ra:open-comment-dialog )
  (void ra:open-song-properties-dialog )
  (void ra:open-audio-device-preferences-dialog )
  (void ra:open-preferences-dialog )
  (void ra:open-midi-preferences-dialog )
  (void ra:open-sequencer-preferences-dialog )
  (void ra:open-tools-dialog )
  (void ra:open-plugin-manager )
  (void ra:open-midi-learn-preferences-dialog )
  (void ra:open-about-window )
  (bool ra:has-conf-path (filepath_t filename ) )
  (filepath_t ra:get-conf-path (filepath_t filename ) )
  (filepath_t ra:get-keybindings-conf-path )
  (filepath_t ra:get-menues-conf-path )
  (filepath_t ra:get-embedded-audio-files-path )
  (void ra:set-embedded-audio-files-path (filepath_t new_path ) )
  (bool ra:save )
  (bool ra:save-as (filepath_t filename createIllegalFilepath()) (bool with_embedded_samples false) (bool ignore_nsm false) )
  (bool ra:export-song (filepath_t filename createIllegalFilepath()) )
  (bool ra:save-with-embedded-samples (bool ignore_nsm false) )
  (bool ra:save-without-embedded-samples (bool ignore_nsm false) )
  (bool ra:save-as-or-export-song (filepath_t filename createIllegalFilepath()) )
  (bool ra:load (bool ignore_nsm false) )
  (bool ra:load-song (filepath_t filename createIllegalFilepath()) )
  (bool ra:import-song (filepath_t filename createIllegalFilepath()) )
  (bool ra:load-or-import-song (filepath_t filename createIllegalFilepath()) )
  (void ra:new-song (bool ignore_nsm false) )
  (void ra:clear-song )
  (void ra:new-or-clear-song )
  (bool ra:has-session )
  (void ra:internal_update-all-block-graphics )
  (void ra:import-midi )
  (void ra:request-import-mod )
  (void ra:import-xm )
  (void ra:insert-tracks (int numtracks ) (int windownum -1) )
  (void ra:insert-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-tracks (int numtracks ) (int windownum -1) )
  (void ra:delete-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-block (int blocknum -1) (int windownum -1) )
  (int ra:insert-block (int windownum -1) )
  (int ra:get-num-tracks (int blocknum -1) )
  (int ra:get-num-lines (int blocknum -1) )
  (int ra:get-num-reallines (int blocknum -1) (int windownum -1) )
  (int ra:get-num-blocks )
  (const_char* ra:get-block-name (int blocknum -1) )
  (void ra:set-block-name (const_char* name ) (int blocknum -1) )
  (void ra:select-block (int blocknum ) (int windownum -1) (bool only_select_if_allowed_to_automatically_change false) )
  (void ra:set-block-color (const_char* color ) (int blocknum -1) (int windownum -1) )
  (const_char* ra:get-block-color (int blocknum -1) (int windownum -1) (bool displayed_color true) )
  (const_char* ra:get-audiofile-color (filepath_t w_audiofilename ) (bool displayed_color true) )
  (void ra:set-audiofile-color (const_char* colorname ) (filepath_t w_audiofilename ) )
  (void ra:show-blocklist-gui )
  (void ra:show-instrument-list-gui )
  (void ra:set-track-note-show-type (int type ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-volume (float volume ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-pan (float pan ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:switch-track-note-show-type (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-block-note-show-type (int type ) (int blocknum -1) (int windownum -1) )
  (void ra:switch-block-note-show-type (int blocknum -1) (int windownum -1) )
  (int ra:get-track-midi-channel (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-midi-channel (int midi_channel ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-swingtext (bool showit ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:swingtext-visible (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-swingtext (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-swingtext-in-block (int blocknum -1) (int windownum -1) )
  (void ra:set-swing-enabled (bool val ) (int blocknum -1) (int windownum -1) )
  (bool ra:get-swing-enabled (int blocknum -1) (int windownum -1) )
  (bool ra:switch-swing-enabled (int blocknum -1) (int windownum -1) )
  (bool ra:centtext-can-be-turned-off (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-centtext (bool showit ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:centtext-visible (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-centtext (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-centtext-in-block (int blocknum -1) (int windownum -1) )
  (void ra:show-chancetext (bool showit ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:chancetext-visible (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-chancetext (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-chancetext-in-block (int blocknum -1) (int windownum -1) )
  (void ra:show-veltext (bool showit ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:veltext-visible (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-veltext (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-veltext-in-block (int blocknum -1) (int windownum -1) )
  (void ra:show-fxtext (bool showit ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:fxtext-visible (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-fxtext (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-fxtext-in-block (int blocknum -1) (int windownum -1) )
  (void ra:show-pianoroll (bool showit ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:pianoroll-visible (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-pianoroll (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-pianoroll-in-block (int blocknum -1) (int windownum -1) )
  (void ra:show-note-track (bool showit ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:note-track-visible (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-note-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-note-tracks-in-block (int blocknum -1) (int windownum -1) )
  (void ra:show-hide-swing-track (int windownum -1) )
  (void ra:set-swing-track-visible (bool setit ) (int windownum -1) )
  (bool ra:swing-track-visible (int windownum -1) )
  (void ra:show-hide-signature-track (int windownum -1) )
  (bool ra:signature-track-visible (int windownum -1) )
  (void ra:set-signature-track-visible (bool showit ) (int windownum -1) )
  (bool ra:lpb-track-visible (int windownum -1) )
  (void ra:set-lpb-track-visible (bool showit ) (int windownum -1) )
  (void ra:show-hide-lpb-track (int windownum -1) )
  (void ra:set-bpm-track-visible (bool setit ) (int windownum -1) )
  (void ra:show-hide-bpm-track (int windownum -1) )
  (bool ra:bpm-track-visible (int windownum -1) )
  (void ra:show-hide-reltempo-track (int windownum -1) )
  (bool ra:reltempo-track-visible (int windownum -1) )
  (void ra:set-reltempo-track-visible (bool setit ) (int windownum -1) )
  (bool ra:linenumbers-visible )
  (void ra:set-linenumbers-visible (bool doit ) )
  (void ra:show-hide-linenumbers )
  (bool ra:smooth-sequencer-scrolling-enabled )
  (void ra:set-smooth-sequencer-scrolling-enabled (bool doit ) )
  (bool ra:autoscroll-sequencer-to-make-playcursor-visible )
  (void ra:set-autoscroll-sequencer-to-make-playcursor-visible (bool doit ) )
  (bool ra:is-using-jack )
  (bool ra:is-using-jack-transport )
  (bool ra:use-jack-transport )
  (void ra:set-use-jack-transport (bool doit ) )
  (bool ra:is-jack-timebase-master )
  (void ra:set-is-jack-timebase-master (bool doit ) )
  (double ra:get-default-audiofile-fadeout )
  (void ra:set-default-audiofile-fadeout (double default_audiofile_fadeout ) )
  (bool ra:do-auto-crossfades )
  (void ra:set-do-auto-crossfades (bool default_do_auto_crossfades ) )
  (bool ra:use-qwerty09-editor-subtracks )
  (void ra:set-use-qwerty09-editor-subtracks (bool val ) )
  (bool ra:use-qwerty-af-editor-subtracks )
  (void ra:set-use-qwerty-af-editor-subtracks (bool val ) )
  (bool ra:use-cpu-friendly-audiometer-updates )
  (void ra:set-use-cpu-friendly-audiometer-updates (bool val ) )
  (bool ra:control-port-open-for-remote-connections )
  (void ra:set-control-port-open-for-remote-connections (bool val ) )
  (bool ra:record-accurately-from-midi )
  (void ra:set-record-accurately-from-midi (bool accurately ) )
  (bool ra:switch-record-accurately-from-midi )
  (bool ra:do-stop-playing-when-saving-song )
  (void ra:set-stop-playing-when-saving-song (bool doit ) )
  (bool ra:do-save-backup-while-playing )
  (void ra:set-save-backup-while-playing (bool val ) )
  (bool ra:save-recorded-audio-files-in-browser-path )
  (void ra:set-save-recorded-audio-files-in-browser-path (bool val ) )
  (bool ra:do-auto-backups )
  (void ra:set-do-auto-backups (bool doit ) )
  (int ra:autobackup-interval-in-minutes )
  (void ra:set-autobackup-interval-in-minutes (int interval ) )
  (bool ra:do-auto-delete-sequencer-recordings )
  (void ra:set-do-auto-delete-sequencer-recordings (bool doit ) )
  (int ra:unused-recording-takes-treatment )
  (void ra:set-unused-recording-takes-treatment (int treatment ) )
  (void ra:add-menu-menu (const_char* name ) (const_char* command ) )
  (void ra:add-menu-menu2 (const_char* name ) (dynvec_t menu_entry_texts ) (func_t* callback ) )
  (void ra:go-previous-menu-level )
  (void ra:add-menu-item (const_char* name ) (const_char* command ) )
  (void ra:add-checkable-menu-item (const_char* name ) (const_char* command ) (int checkval 0) )
  (void ra:add-menu-separator )
  (int64_t ra:set-statusbar-text (const_char* text ) )
  (void ra:remove-statusbar-text (int64_t id ) )
  (void ra:erase-estimated-vblank )
  (int ra:get-webserver-port )
  (dyn_t ra:eval-scheme-with-return (const_char* code ) )
  (void ra:eval-scheme (const_char* code ) )
  (bool ra:error-check-eval-scheme )
  (void ra:set-error-check-eval-scheme (bool error_check ) )
  (void ra:eval-python (const_char* code ) )
  (void ra:add-keybinding (const_char* command ) (const_char* keys ) )
  (dyn_t ra:get-keybindings-from-commands )
  (dynvec_t ra:get-keybindings-from-command (const_char* command ) )
  (dyn_t ra:get-keybindings-from-keys )
  (const_char* ra:get-keybinding-from-keys (const_char* keys ) )
  (const_char* ra:get-qualifier-name (const_char* qualifier ) )
  (void ra:reload-keybindings )
  (void ra:add-keybinding-to-conf-file (const_char* keybinding ) (const_char* funcname ) (dynvec_t arguments ) )
  (void ra:remove-keybinding-from-conf-file (const_char* keybinding ) (const_char* funcname ) (dynvec_t arguments ) )
  (void ra:grab-keybinding (func_t* callback ) )
  (void ra:cancel-grab-keybinding )
  (void ra:send-key-event (const_char* keybinding ) )
  (bool ra:is-full-version )
  (int ra:radium-major-version )
  (int ra:radium-minor-version )
  (int ra:radium-revision-version )
  (bool ra:vst-gui-is-always-on-top )
  (void ra:set-vst-gui-always-on-top (bool doit ) )
  (bool ra:show-virtual-midi-keyboard-below-native-gu-is )
  (void ra:set-show-virtual-midi-keyboard-below-native-gu-is (bool doit ) )
  (bool ra:do-modal-windows )
  (void ra:set-modal-windows (bool doit ) )
  (bool ra:do-high-cpu-open-gl-protection )
  (void ra:set-high-cpu-open-gl-protection (bool doit ) )
  (bool ra:do-lock-juce-when-swapping-open-gl )
  (void ra:set-lock-juce-when-swapping-open-gl (bool doit ) )
  (bool ra:use-native-file-requesters )
  (void ra:set-use-native-file-requesters (bool doit ) )
  (float ra:get-instrument-brightness )
  (void ra:set-instrument-brightness (float val ) )
  (float ra:get-instrument-brightness-in-editor )
  (void ra:set-instrument-brightness-in-editor (float val ) )
  (float ra:get-instrument-saturation )
  (void ra:set-instrument-saturation (float val ) )
  (float ra:get-instrument-saturation-in-editor )
  (void ra:set-instrument-saturation-in-editor (float val ) )
  (float ra:get-block-brightness )
  (void ra:set-block-brightness (float val ) )
  (float ra:get-block-saturation )
  (void ra:set-block-saturation (float val ) )
  (float ra:get-amount-of-gradient )
  (void ra:set-amount-of-gradient (float val ) )
  (void ra:print-mixer-tree )
  (void ra:test-crashreporter )
  (void ra:test-crashreporter-in-audio-thread )
  (void ra:test-error-message )
  (void ra:start-autotesting-mode )
  (void ra:stop-autotesting-mode )
  (bool ra:is-in-autotesting-mode )
  (int64_t ra:get-gc-memory-usage )
  (void ra:disable-scheme-history )
  (void ra:enable-scheme-history )
  (int ra:get-faust-optimization-level )
  (void ra:set-faust-optimization-level (int level ) )
  (const_char* ra:get-faust-gui-style )
  (void ra:set-faust-gui-style (const_char* style ) )
  (int64_t ra:get-block-length (int blocknum -1) (int windownum -1) )
  (double ra:get-song-length )
  (int64_t ra:get-song-length-in-frames )
  (int ra:get-sample-rate )
  (dyn_t ra:get-cpu-usage )
  (int ra:get-num-xruns )
  (int64_t ra:get-editor-blocks-generation )
  (int ra:get-logtype-hold )
  (int ra:get-logtype-linear )
  (Place ra:get-cursor-place (int blocknum -1) (int windownum -1) )
  (int ra:get-cursor-track (int windownum -1) )
  (int ra:get-highest-legal-place-denominator )
  (int ra:get-numerator-from-ratio-string (const_char* s ) )
  (int ra:get-denominator-from-ratio-string (const_char* s ) )
  (dyn_t ra:get-ratio-from-string (const_char* s ) )
  (const_char* ra:get-string-from-ratio (dyn_t ratio ) )
  (const_char* ra:to-base64 (const_char* s ) )
  (const_char* ra:from-base64 (const_char* w ) )
  (const_char* ra:append-base64-strings (const_char* w1 ) (const_char* w2 ) )
  (bool ra:base64-string-is-8bit-compatible (const_char* w ) )
  (int ra:get-string-length (const_char* s ) )
  (const_char* ra:create-uuid )
  (void ra:msleep (int ms ) )
  (double ra:get-ms )
  (int64_t ra:get-pid )
  (const_char* ra:get-argv0 )
  (bool ra:release-mode )
  (bool ra:optimized-build )
  (const_char* ra:get-os-name )
  (const_char* ra:get-architecture-name )
  (const_char* ra:get-program-log )
  (void ra:add-to-program-log (const_char* text ) )
  (void ra:copy-wtext-to-clipboard (const_char* wtext ) )
  (const_char* ra:get-clipboard-wtext )
  (void ra:copy-text-to-clipboard (const_char* text ) )
  (const_char* ra:get-clipboard-text )
  (void ra:copy-filepath-to-clipboard (filepath_t filepath ) )
  (filepath_t ra:get-clipboard-filepath )
  (void ra:schedule (double ms ) (func_t* callback ) )
  (void ra:remove-schedule (func_t* callback ) )
  (dynvec_t ra:string-split (const_char* string ) (const_char* split ) (bool keep_empty_parts true) )
  (int64_t ra:create-osc-server (const_char* port "") (int protocol 0) )
  (void ra:close-osc-server (int64_t server_id ) )
  (int ra:get-osc-protocol-from-url (const_char* url ) )
  (int64_t ra:add-osc-method (int64_t server_id ) (const_char* path ) (const_char* typespec ) (func_t* callback ) )
  (void ra:close-osc-method (int64_t method_id ) )
  (void ra:send-osc-message (const_char* url ) (const_char* path ) (const_char* typespec ) (dynvec_t args ) )
  (void ra:send-osc-message-from (const_char* url ) (int64_t server_id ) (const_char* path ) (const_char* typespec ) (dynvec_t args ) )
  (bool ra:nsm-has-inited )
  (void ra:wait-until-nsm-has-inited )
  (bool ra:nsm-is-active )
  (const_char* ra:get-nsm-client-id )
  (bool ra:supports-switch-nsm-capability )
  (void ra:set-supports-switch-nsm-capability (bool do_switch ) )
  (void ra:nsm-new-song )
  (void ra:nsm-save )
  (void ra:nsm-duplicate )
  (bool ra:nsm-open )
  (void ra:nsm-quit )
  (void ra:send-midi-message (int64_t port ) (int byte1 ) (int byte2 -1) (int byte3 -1) )
  (void ra:send-midi-sysex (int64_t port_id ) (dynvec_t bytes ) )
  (int64_t ra:open-midi-output-port (const_char* portname ) (bool create_new_port_if_not_existing true) )
  (void ra:close-midi-output-port (int64_t portnum ) )
  (int64_t ra:open-midi-input-port (const_char* portname ) (func_t* callback ) (bool create_new_port_if_not_existing true) )
  (void ra:close-midi-input-port (int64_t portnum ) (bool throw_error_if_already_closed true) )
  (void ra:close-all-midi-input-ports )
  (dynvec_t ra:get-midi-output-port-names )
  (dynvec_t ra:get-midi-input-port-names )
  (filepath_t ra:create-illegal-filepath )
  (bool ra:is-illegal-filepath (filepath_t filepath ) )
  (bool ra:is-legal-filepath (filepath_t filepath ) )
  (const_char* ra:get-base64-from-filepath (filepath_t filepath ) )
  (filepath_t ra:get-filepath-from-base64 (const_char* base64text ) )
  (filepath_t ra:get-path (const_char* path_string ) )
  (filepath_t ra:get-home-path )
  (filepath_t ra:get-program-path )
  (const_char* ra:get-path-string (filepath_t filepath ) )
  (filepath_t ra:append-file-paths (filepath_t path1 ) (filepath_t path2 ) )
  (filepath_t ra:get-parent-path (filepath_t path ) )
  (filepath_t ra:get-dir-path (filepath_t path ) )
  (filepath_t ra:get-path-without-dir (filepath_t path ) )
  (bool ra:file-exists (filepath_t filepath ) )
  (dyn_t ra:get-file-info (filepath_t path ) )
  (bool ra:dir-exists (filepath_t path ) )
  (bool ra:create-dir (filepath_t path ) )
  (bool ra:iterate-directory (filepath_t path ) (bool async ) (func_t* callback ) )
  (file_t ra:create-illegal-file )
  (bool ra:is-illegal-file (file_t file ) )
  (file_t ra:open-file-for-reading (filepath_t path ) )
  (file_t ra:open-file-for-writing (filepath_t path ) )
  (bool ra:close-file (file_t file ) )
  (bool ra:write-to-file (file_t file ) (const_char* string ) )
  (bool ra:file-at-end (file_t disknum ) )
  (const_char* ra:read-line-from-file (file_t file ) )
  (file_t ra:open-file-for-binary-reading (filepath_t path ) )
  (int ra:read-le32-from-file (file_t disknum ) )
  (int64_t ra:read-le-u32-from-file (file_t disknum ) )
  (int64_t ra:read-be-u32-from-file (file_t disknum ) )
  (int ra:read-le16-from-file (file_t disknum ) )
  (int ra:read-be-u16-from-file (file_t disknum ) )
  (int ra:read8-from-file (file_t disknum ) )
  (int ra:read-u8-from-file (file_t disknum ) )
  (void ra:put-settings (const_char* key ) (const_char* value ) )
  (void ra:put-settings-w (const_char* key ) (const_char* w_value ) )
  (void ra:put-settings-f (const_char* key ) (filepath_t w_value ) )
  (const_char* ra:get-settings (const_char* key ) (const_char* default_value ) )
  (const_char* ra:get-settings-w (const_char* key ) (const_char* default_w_value ) )
  (filepath_t ra:get-settings-f (const_char* key ) (filepath_t default_w_value ) )
  (dyn_t ra:get-all-settings (const_char* starting_with_string "") )
  (bool ra:autobypass-enabled )
  (void ra:set-autobypass-enabled (bool doit ) )
  (int ra:get-auto-bypass-delay )
  (void ra:set-autobypass-delay (int ms ) )
  (bool ra:latency-compensation-enabled )
  (void ra:set-latency-compensation-enabled (bool doit ) )
  (bool ra:get-recording-latency-from-system-input-is-automatically-determined )
  (void ra:set-recording-latency-from-system-input-is-automatically-determined (bool new_value ) )
  (double ra:get-custom-recording-latency-from-system-input )
  (void ra:set-custom-recording-latency-from-system-input (double ms ) )
  (int ra:get-midi-instrument-latency-type )
  (void ra:set-midi-instrument-latency-type (int type ) )
  (double ra:get-custom-midi-instrument-latency )
  (void ra:set-custom-midi-instrument-latency (double ms ) )
  (bool ra:get-check-abnormal-signals )
  (void ra:set-check-abnormal-signals (bool new_val ) )
  (bool ra:do-undo-solo )
  (void ra:set-undo-solo (bool doit ) )
  (bool ra:do-undo-bypass )
  (void ra:set-undo-bypass (bool doit ) )
  (void ra:select-instrument-for-track (int tracknum -1) )
  (void ra:request-replace-instrument (instrument_t instrument_id getCurrentInstrumentUnderMouse()) (const_char* instrument_description "") (int64_t parentgui -2) )
  (void ra:request-load-instrument-preset (instrument_t instrument_id getCurrentInstrumentUnderMouse()) (const_char* instrument_description "") (int64_t parentgui -2) )
  (void ra:save-instrument-preset (dynvec_t instrument_ids g_empty_dynvec) (int64_t parentgui -2) )
  (filepath_t ra:get-instrument-preset-path (instrument_t instrument_id createIllegalInstrument()) )
  (filepath_t ra:get-instrument-preset (instrument_t instrument_id ) )
  (void ra:replace-use-of-instrument (instrument_t old_instrument_id ) (instrument_t new_instrument_id ) )
  (void ra:set-instrument-for-track (instrument_t instrument_id ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (instrument_t ra:get-instrument-for-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:has-instrument-for-track (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:is-legal-instrument (instrument_t instrument_id ) )
  (instrument_t ra:create-illegal-instrument )
  (void ra:set-instrument-name (const_char* name ) (instrument_t instrument_id ) )
  (const_char* ra:get-instrument-name (instrument_t instrument_id ) )
  (const_char* ra:get-instrument-comment (instrument_t instrument_id ) )
  (void ra:set-instrument-comment (const_char* comment ) (instrument_t instrument_id ) )
  (bool ra:instrument-name-was-autogenerated (instrument_t instrument_id ) )
  (bool ra:has-pure-data )
  (bool ra:instrument-supports-changing-pitch-of-playing-note (instrument_t instrument_id createIllegalInstrument()) (bool include_event_connected_instruments false) )
  (bool ra:instrument-does-not-support-changing-pitch-of-playing-note (instrument_t instrument_id createIllegalInstrument()) (bool include_event_connected_instruments false) )
  (bool ra:has-native-instrument-gui (instrument_t instrument_id ) )
  (bool ra:show-instrument-gui (instrument_t instrument_id getCurrentInstrumentUnderMouse()) (int64_t parentgui -2) (bool show_instrument_window_if_not_visible false) )
  (bool ra:hide-instrument-gui (instrument_t instrument_id getCurrentInstrumentUnderMouse()) )
  (bool ra:instrument-gui-is-visible (instrument_t instrument_id ) (int64_t parentgui ) )
  (void ra:internal_instrument-gui-has-been-hidden (instrument_t instrument_id ) )
  (bool ra:show-hide-instrument-gui (instrument_t instrument_id getCurrentInstrumentUnderMouse()) (int64_t parentgui -2) (bool show_instrument_window_if_not_visible false) )
  (void ra:select-instrument-config-num (int confignum ) (instrument_t instrument_id getCurrentInstrumentUnderMouse()) )
  (void ra:reset-instrument-config-num (int confignum -1) (instrument_t instrument_id getCurrentInstrumentUnderMouse()) )
  (int ra:get-curr-instrument-config-num (instrument_t instrument_id getCurrentInstrumentUnderMouse()) )
  (bool ra:instrument-config-num-is-used (int confignum ) (instrument_t instrument_id getCurrentInstrumentUnderMouse()) )
  (instrument_t ra:get-current-instrument-under-mouse )
  (void ra:set-current-instrument-under-mouse (instrument_t instrument ) )
  (bool ra:mouse-pointer-currently-points-at-instrument )
  (instrument_t ra:get-current-instrument )
  (void ra:set-current-instrument (instrument_t instrument_id ) (bool show_instrument_window_if_not_visible false) (bool only_change_if_unlocked false) )
  (void ra:set-current-instrument-left (bool set_current_instrument false) (bool set_current_instrument_under_mouse true) )
  (void ra:set-current-instrument-right (bool set_current_instrument false) (bool set_current_instrument_under_mouse true) )
  (void ra:set-current-instrument-up (bool set_current_instrument false) (bool set_current_instrument_under_mouse true) )
  (void ra:set-current-instrument-down (bool set_current_instrument false) (bool set_current_instrument_under_mouse true) )
  (void ra:add-current-instrument-changed-callback (func_t* callback ) )
  (void ra:remove-current-instrument-changed-callback (func_t* callback ) )
  (void ra:add-current-instrument-under-mouse-changed-callback (func_t* callback ) )
  (void ra:remove-current-instrument-under-mouse-changed-callback (func_t* callback ) )
  (void ra:show-instrument-info (dyn_t instrument_id_or_description g_uninitialized_dyn) (int64_t parentgui -2) )
  (int64_t ra:get-instrument-deletion-generation )
  (int64_t ra:get-audio-instrument-deletion-generation )
  (instrument_t ra:create-audio-instrument (const_char* type_name ) (const_char* plugin_name ) (const_char* name "") (float x 0) (float y 0) (bool set_as_current true) (bool is_visible true) )
  (instrument_t ra:create-audio-instrument-from-preset (filepath_t filename ) (const_char* name "") (float x 0) (float y 0) (bool set_as_current true) (bool is_visible true) )
  (const_char* ra:get-audio-instrument-description (const_char* container_name ) (const_char* type_name ) (const_char* plugin_name ) )
  (instrument_t ra:create-audio-instrument-from-description (const_char* instrument_description ) (const_char* name "") (float x 0) (float y 0) (bool set_as_current true) (bool is_visible true) )
  (instrument_t ra:clone-audio-instrument (instrument_t instrument_id ) (float x 0) (float y 0) (bool set_as_current true) )
  (dyn_t ra:create-new-instrument-conf (float x 0) (float y 0) (bool connect_to_main_pipe false) (bool do_autoconnect false) (bool include_load_preset true) (bool must_have_inputs false) (bool must_have_outputs false) (int64_t parentgui -2) )
  (void ra:create-instrument-description-popup-menu (dyn_t instrument_conf ) )
  (dynvec_t ra:get-all-single-presets-in-path (filepath_t path createIllegalFilepath()) )
  (dynvec_t ra:get-all-multi-presets-in-path (filepath_t path createIllegalFilepath()) )
  (void ra:request-load-preset-instrument-description (int64_t parentgui ) (func_t* callback ) )
  (bool ra:instrument-preset-in-clipboard )
  (void ra:set-instrument-sample (instrument_t instrument_id ) (filepath_t filename ) )
  (void ra:set-random-instrument-sample (instrument_t instrument_id ) (filepath_t path createIllegalFilepath()) )
  (void ra:set-random-sample-for-all-selected-instruments )
  (void ra:set-instrument-loop-data (instrument_t instrument_id ) (int64_t start ) (int64_t length ) )
  (bool ra:keep-old-loop-when-loading-new-sample )
  (void ra:set-keep-old-loop-when-loading-new-sample (bool new_val ) )
  (bool ra:use-same-loop-frames-when-loading-new-sample )
  (void ra:set-use-same-loop-frames-when-loading-new-sample (bool new_val ) )
  (void ra:set-instrument-color (const_char* colorname ) (instrument_t instrument_id createIllegalInstrument()) )
  (void ra:generate-new-instrument-color (instrument_t instrument_id createIllegalInstrument()) (float mix_background 0.9) )
  (void ra:generate-new-color-for-all-selected-instruments (float mix_background 0.9) )
  (const_char* ra:get-instrument-color (instrument_t instrument_id ) (bool get_displayed_color true) )
  (const_char* ra:get-instrument-type-name (instrument_t instrument_id ) )
  (const_char* ra:get-instrument-plugin-name (instrument_t instrument_id ) )
  (int ra:get-num-instrument-programs (instrument_t instrument_id ) )
  (int ra:get-curr-instrument-program (instrument_t instrument_id ) )
  (void ra:set-curr-instrument-program (instrument_t instrument_id ) (int program ) )
  (void ra:set-instrument-program-name (instrument_t instrument_id ) (int program ) (const_char* new_name ) )
  (const_char* ra:get-instrument-program-name (instrument_t instrument_id ) (int program ) )
  (bool ra:instrument-has-been-used (instrument_t instrument_id ) )
  (const_char* ra:get-instrument-effect-name (int effect_num ) (instrument_t instrument_id ) )
  (int ra:get-num-instrument-effects (instrument_t instrument_id ) )
  (void ra:reset-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) )
  (bool ra:instrument-effect-exists (instrument_t instrument ) (const_char* effect_name ) )
  (float ra:get-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) )
  (float ra:get-native-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) )
  (float ra:get-stored-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) )
  (float ra:get-stored-native-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) )
  (float ra:get-default-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) )
  (void ra:set-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) (float value ) )
  (void ra:set-native-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) (float value ) )
  (dyn_t ra:get-instrument-effects (instrument_t instrument_id ) )
  (void ra:set-instrument-effects (instrument_t instrument_id ) (dyn_t effects ) (bool set_default_values_for_unspecified_effects false) )
  (void ra:undo-instrument-effect (instrument_t instrument_id ) (const_char* effect_name ) )
  (int ra:get-instrument-effect-type (instrument_t instrument_id ) (const_char* effect_name ) )
  (const_char* ra:get-instrument-effect-color (instrument_t instrument_id ) (const_char* effect_name ) )
  (bool ra:instrument-effect-has-midi-learn (instrument_t instrument_id ) (const_char* effect_name ) )
  (void ra:add-instrument-effect-midi-learn (instrument_t instrument_id ) (const_char* effect_name ) )
  (void ra:remove-instrument-effect-midi-learn (instrument_t instrument_id ) (const_char* effect_name ) )
  (bool ra:instrument-effect-midi-learn-is-incremental (instrument_t instrument_id ) (const_char* effect_name ) )
  (void ra:set-instrument-effect-midi-learn-is-incremental (instrument_t instrument_id ) (const_char* effect_name ) (bool is_incremental ) )
  (bool ra:add-automation-to-current-editor-track (instrument_t instrument_id ) (const_char* effect_name ) )
  (bool ra:add-automation-to-current-sequencer-track (instrument_t instrument_id ) (const_char* effect_name ) )
  (void ra:set-instrument-effect-changes-value-when-pressing-random (instrument_t instrument_id ) (const_char* effect_name ) (bool doit ) )
  (bool ra:get-instrument-effect-changes-value-when-pressing-random (instrument_t instrument_id ) (const_char* effect_name ) )
  (void ra:start-recording-instrument-automation-in-editor (instrument_t instrument_id ) (const_char* effect_name ) (bool do_start_recording_not_stop_recording true) )
  (bool ra:get-instrument-solo (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:get-instrument-mute (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:get-instrument-bypass (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:get-instrument-solo-from-storage (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:get-instrument-mute-from-storage (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:get-instrument-bypass-from-storage (instrument_t instrument_id createIllegalInstrument()) )
  (void ra:set-instrument-solo (bool do_solo ) (instrument_t instrument_id createIllegalInstrument()) )
  (void ra:set-instrument-mute (bool do_mute ) (instrument_t instrument_id createIllegalInstrument()) )
  (void ra:set-instrument-bypass (bool do_bypass ) (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:switch-instrument-solo (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:switch-instrument-mute (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:switch-instrument-bypass (instrument_t instrument_id createIllegalInstrument()) )
  (void ra:set-solo-for-instruments (dynvec_t instruments ) (bool doit ) )
  (void ra:set-mute-for-instruments (dynvec_t instruments ) (bool doit ) )
  (void ra:set-bypass-for-instruments (dynvec_t instruments ) (bool doit ) )
  (void ra:switch-solo-for-selected-instruments )
  (void ra:switch-mute-for-selected-instruments )
  (void ra:switch-bypass-for-selected-instruments )
  (bool ra:at-least-one-instrument-has-solo )
  (bool ra:instrument-is-implicitly-muted (instrument_t instrument_id ) )
  (bool ra:instrument-is-implicitly-soloed (instrument_t instrument_id ) )
  (float ra:get-min-db )
  (float ra:get-max-db )
  (float ra:get-max-volume-slider-db )
  (float ra:db-to-gain (float db ) )
  (float ra:gain-to-db (float gain ) )
  (bool ra:instrument-is-audio (instrument_t instrument_id ) )
  (int ra:get-num-midi-instruments )
  (instrument_t ra:get-midi-instrument-id (int instrument_num ) )
  (int ra:get-num-audio-instruments )
  (instrument_t ra:get-audio-instrument-id (int instrument_num ) )
  (int ra:get-audio-instrument-num (instrument_t instrument_id ) )
  (instrument_t ra:get-audio-bus-id (int bus_num ) )
  (dynvec_t ra:get-instruments )
  (dynvec_t ra:get-midi-instruments )
  (dynvec_t ra:get-audio-instruments )
  (dynvec_t ra:get-buses )
  (bool ra:instrument-is-bus (instrument_t instrument_id ) )
  (bool ra:instrument-is-permanent (instrument_t instrument_id ) )
  (float ra:get-instrument-x (instrument_t instrument_id ) )
  (float ra:get-instrument-y (instrument_t instrument_id ) )
  (void ra:set-instrument-position (float x ) (float y ) (instrument_t instrument_id ) (bool auto_slot false) )
  (void ra:autoposition-instrument (instrument_t instrument_id ) )
  (dynvec_t ra:get-curr-mixer-instruments )
  (dynvec_t ra:get-selected-instruments )
  (int ra:num-selected-instruments )
  (bool ra:instrument-is-selected (instrument_t instrument_id ) )
  (void ra:set-instrument-is-selected (instrument_t instrument_id ) (bool doit ) )
  (void ra:switch-instrument-is-selected (instrument_t instrument_id ) )
  (const_char* ra:get-instrument-info (instrument_t instrument_id ) )
  (void ra:connect-audio-instrument-to-main-pipe (instrument_t instrument_id ) )
  (bool ra:autoconnect-instrument (instrument_t instrument_id ) (float x ) (float y ) )
  (int ra:get-num-in-audio-connections (instrument_t instrument_id ) )
  (int ra:get-num-out-audio-connections (instrument_t instrument_id ) )
  (instrument_t ra:get-audio-connection-source-instrument (int inconnection ) (instrument_t instrument_id ) )
  (instrument_t ra:get-audio-connection-dest-instrument (int inconnection ) (instrument_t instrument_id ) )
  (void ra:undo-mixer-connections )
  (void ra:create-audio-connection (instrument_t source_id ) (instrument_t dest_id ) (float gain 1.0) (int connection_type 1) )
  (void ra:create-event-connection (instrument_t source_id ) (instrument_t dest_id ) )
  (void ra:delete-audio-connection (instrument_t source_id ) (instrument_t dest_id ) )
  (void ra:delete-event-connection (instrument_t source_id ) (instrument_t dest_id ) )
  (bool ra:can-audio-connect (instrument_t source_id ) (instrument_t dest_id ) )
  (bool ra:change-audio-connections (dynvec_t changes ) )
  (bool ra:has-audio-connection (instrument_t source_id ) (instrument_t dest_id ) )
  (bool ra:has-event-connection (instrument_t source_id ) (instrument_t dest_id ) )
  (bool ra:get-connection-implicitly-disabled (instrument_t source_id ) (instrument_t dest_id ) )
  (bool ra:get-connection-enabled (instrument_t source_id ) (instrument_t dest_id ) (bool show_error_if_not_connected true) )
  (void ra:set-connection-enabled (instrument_t source_id ) (instrument_t dest_id ) (bool is_enabled ) (bool redraw_mixer_strips true) )
  (void ra:undo-connection-enabled (instrument_t source_id ) (instrument_t dest_id ) )
  (float ra:get-audio-connection-gain (instrument_t source_id ) (instrument_t dest_id ) (bool show_error_if_not_connected true) )
  (void ra:set-audio-connection-gain (instrument_t source_id ) (instrument_t dest_id ) (float gain ) (bool redraw_mixer_strips true) )
  (void ra:undo-audio-connection-gain (instrument_t source_id ) (instrument_t dest_id ) )
  (int ra:get-audio-connection-type (instrument_t source_id ) (instrument_t dest_id ) )
  (void ra:set-audio-connection-type (instrument_t source_id ) (instrument_t dest_id ) (int audio_connection_type ) )
  (int ra:get-num-in-event-connections (instrument_t instrument_id ) )
  (int ra:get-num-out-event-connections (instrument_t instrument_id ) )
  (instrument_t ra:get-event-connection-source-instrument (int inconnection ) (instrument_t instrument_id ) )
  (instrument_t ra:get-event-connection-dest-instrument (int inconnection ) (instrument_t instrument_id ) )
  (bool ra:has-event-connection-under-mouse )
  (bool ra:has-audio-connection-under-mouse )
  (instrument_t ra:get-event-connection-under-mouse-source-instrument )
  (instrument_t ra:get-event-connection-under-mouse-dest-instrument )
  (instrument_t ra:get-audio-connection-under-mouse-source-instrument )
  (instrument_t ra:get-audio-connection-under-mouse-dest-instrument )
  (void ra:set-curr-mixer-config-num (int num ) )
  (void ra:reset-mixer-config-num (int num -1) )
  (bool ra:mixer-config-num-is-used (int num ) )
  (bool ra:include-audio-connections-in-mixer-config )
  (void ra:set-include-audio-connections-in-mixer-config (bool doit ) )
  (bool ra:include-event-connections-in-mixer-config )
  (void ra:set-include-event-connections-in-mixer-config (bool doit ) )
  (bool ra:include-volume-in-mixer-config )
  (void ra:set-include-volume-in-mixer-config (bool doit ) )
  (bool ra:include-panning-in-mixer-config )
  (void ra:set-include-panning-in-mixer-config (bool doit ) )
  (bool ra:include-mute-solo-bypass-in-mixer-config )
  (void ra:set-include-mute-solo-bypass-in-mixer-config (bool doit ) )
  (bool ra:include-system-effects-in-mixer-config )
  (void ra:set-include-system-effects-in-mixer-config (bool doit ) )
  (bool ra:include-instrument-effects-in-mixer-config )
  (void ra:set-include-instrument-effects-in-mixer-config (bool doit ) )
  (bool ra:include-instrument-states-in-mixer-config )
  (void ra:set-include-instrument-states-in-mixer-config (bool doit ) )
  (bool ra:include-mixer-strips-configuration-in-mixer-config )
  (void ra:set-include-mixer-strips-configuration-in-mixer-config (bool doit ) )
  (bool ra:include-remember-current-instrument-in-mixer-config )
  (void ra:set-include-remember-current-instrument-in-mixer-config (bool doit ) )
  (bool ra:include-modulator-connections-in-mixer-config )
  (void ra:set-include-modulator-connections-in-mixer-config (bool doit ) )
  (bool ra:include-system-volume-in-mixer-config )
  (void ra:set-include-system-volume-in-mixer-config (bool doit ) )
  (instrument_t ra:create-modulator )
  (bool ra:has-modulator (instrument_t instrument_id ) (const_char* effect_name ) )
  (void ra:add-modulator (instrument_t instrument_id ) (const_char* effect_name ) (instrument_t modulator_instrument_id createIllegalInstrument()) )
  (void ra:replace-modulator (instrument_t instrument_id ) (const_char* effect_name ) (instrument_t modulator_instrument_id createIllegalInstrument()) )
  (void ra:remove-modulator (instrument_t instrument_id ) (const_char* effect_name ) )
  (const_char* ra:get-modulator-description (instrument_t instrument_id ) (const_char* effect_name ) )
  (const_char* ra:get-modulator-description2 (instrument_t instrument_id ) (int effect_num ) )
  (const_char* ra:get-modulator-description3 (instrument_t modulator_instrument_id ) )
  (dynvec_t ra:get-modulator-instruments )
  (dynvec_t ra:get-modulator-targets (instrument_t modulator_instrument_id ) )
  (void ra:set-modulator-enabled (instrument_t instrument_id ) (const_char* effect_name ) (bool enabled ) )
  (bool ra:get-modulator-enabled (instrument_t instrument_id ) (const_char* effect_name ) )
  (int ra:get-num-input-channels (instrument_t instrument_id ) )
  (int ra:get-num-output-channels (instrument_t instrument_id ) )
  (void ra:delete-instrument (instrument_t instrument_id getCurrentInstrumentUnderMouse()) )
  (void ra:internal-replace-main-pipe (instrument_t new_main_pipe_id ) )
  (instrument_t ra:internal-replace-permanent (instrument_t id_old ) (instrument_t id_new ) )
  (instrument_t ra:get-main-pipe-instrument )
  (bool ra:instrument-is-open (instrument_t instrument_id ) )
  (bool ra:instrument-is-open-and-audio (instrument_t instrument_id ) )
  (bool ra:instrument-is-visible (instrument_t instrument_id ) )
  (filepath_t ra:get-sample-bookmarks (int num ) (filepath_t default_path getHomePath()) )
  (void ra:set-sample-bookmarks (int num ) (filepath_t default_path getHomePath()) )
  (bool ra:do-split-into-monophonic-tracks-after-recording-from-midi )
  (void ra:set-split-into-monophonic-tracks-after-recording-from-midi (bool doit ) )
  (bool ra:do-use-track-channel-for-midi-input )
  (void ra:set-use-track-channel-for-midi-input (bool doit ) )
  (bool ra:is-sending-midi-input-to-current-instrument )
  (void ra:set-send-midi-input-to-current-instrument (bool doit ) )
  (instrument_t ra:create-midi-instrument (const_char* name ) )
  (void ra:set-instrument-data (instrument_t instrument_id ) (const_char* key ) (const_char* value ) )
  (const_char* ra:get-instrument-data (instrument_t instrument_id ) (const_char* key ) )
  (void ra:midi_reset-all-controllers )
  (void ra:midi_local-keyboard-on )
  (void ra:midi_local-keyboard-off )
  (void ra:midi_all-notes-off )
  (void ra:midi_all-sounds-off )
  (void ra:midi_record-accurately (bool accurately ) )
  (void ra:midi_always-record-velocity (bool doit ) )
  (void ra:midi_set-input-port )
  (int ra:play-note (float pitch ) (float velocity ) (float pan ) (int midi_channel ) (instrument_t instrument_id ) )
  (void ra:change-note-pitch (float pitch ) (int playnote_id ) (int midi_channel ) (instrument_t instrument_id ) )
  (void ra:stop-note (int playnote_id ) (int midi_channel ) (instrument_t instrument_id ) )
  (int64_t ra:add-effect-monitor (const_char* effect_name ) (instrument_t instrument_id ) (bool monitor_stored ) (bool monitor_automation ) (func_t* func ) )
  (void ra:remove-effect-monitor (int64_t effect_monitor_id ) (bool throw_exception_if_not_found ) )
  (void ra:redraw-mixer-strips (bool immediately true) )
  (void ra:remake-mixer-strips (instrument_t instrument_id createIllegalInstrument()) )
  (bool ra:has-wide-instrument-strip (instrument_t instrument_id ) )
  (void ra:set-wide-instrument-strip (instrument_t instrument_id ) (bool is_wide ) )
  (bool ra:switch-wide-instrument-strip (instrument_t instrument_id getCurrentInstrumentUnderMouse()) )
  (void ra:set-mixer-strip-comments-visible (bool val ) )
  (bool ra:mixer-strip-comments-visible )
  (void ra:set-include-pan-and-dry-in-wet-signal (bool val ) )
  (bool ra:include-pan-and-dry-in-wet-signal )
  (void ra:set-mute-system-buses-when-bypassed (bool val ) )
  (bool ra:mute-system-buses-when-bypassed )
  (bool ra:enable-sample-seek-by-default )
  (void ra:set-enable-sample-seek-by-default (bool doit ) )
  (int ra:get-sound-plugin-registry-generation )
  (dynvec_t ra:get-sound-plugin-registry (bool only_normal_and_containers false) )
  (dynvec_t ra:populate-plugin-container (dyn_t entry ) )
  (void ra:clear-sound-plugin-registry )
  (void ra:set-default-colors1 )
  (void ra:set-default-colors2 )
  (void ra:config-system-font )
  (void ra:config-fonts (int windownum -1) )
  (void ra:set-default-editor-font )
  (void ra:set-default-system-font )
  (void ra:set-editor-font (const_char* fontdescr ) )
  (void ra:set-system-font (const_char* fontdescr ) )
  (const_char* ra:get-editor-font )
  (const_char* ra:get-system-font )
  (const_char* ra:get-sample-browser-font (bool mono_font ) )
  (void ra:config-window (int windownum -1) )
  (void ra:config-block (int blocknum -1) (int windownum -1) )
  (void ra:config-vst (int windownum -1) )
  (bool ra:vst-config-open )
  (filepath_t ra:get-load-filename (const_char* text ) (const_char* filetypes ) (filepath_t dir createIllegalFilepath()) (const_char* type "") )
  (filepath_t ra:get-save-filename (const_char* text ) (const_char* filetypes ) (filepath_t dir createIllegalFilepath()) (const_char* type "") (const_char* default_suffix "") )
  (void ra:open-requester (const_char* text ) (int width 50) (int height 20) )
  (void ra:close-requester )
  (bool ra:safe-to-call-close-requester )
  (int ra:request-integer (const_char* text ) (int min ) (int max ) (bool standaline false) (const_char* default_value "") )
  (float ra:request-float (const_char* text ) (float min ) (float max ) (bool standaline false) (const_char* default_value "") )
  (const_char* ra:request-string (const_char* text ) (bool standalone false) (const_char* default_value "") )
  (const_char* ra:request-w-string (const_char* text ) (bool standalone false) (const_char* default_w_value "") )
  (bool ra:request-was-cancelled )
  (int64_t ra:popup-menu (dynvec_t menu_entry_texts ) (func_t* callback ) )
  (int64_t ra:get-last-hovered-popup-menu-entry )
  (void ra:hover-popup-menu-entry (int entryid ) )
  (void ra:rightclick-popup-menu-entry (int entryid ) )
  (void ra:add-popup-menu-closed-callback (func_t* callback ) )
  (void ra:remove-popup-menu-closed-callback (func_t* callback ) )
  (void ra:color-dialog (const_char* initial_color ) (int64_t parentgui ) (func_t* callback ) )
  (const_char* ra:request-midi-port )
  (const_char* ra:show-message (const_char* text ) (dyn_t buttons g_uninitialized_dyn) )
  (const_char* ra:show-message2 (const_char* text ) )
  (void ra:show-async-message (const_char* text ) )
  (void ra:add-message (const_char* html ) )
  (void ra:show-warning (const_char* text ) )
  (void ra:show-error (const_char* text ) )
  (void ra:open-progress-window (const_char* message ) (bool message_is_base64 false) )
  (void ra:show-progress-window-message (const_char* message ) (bool force_show true) )
  (void ra:show-progress-window-message-if-open (const_char* message ) (bool force_show true) )
  (void ra:close-progress-window )
  (bool ra:progress-window-is-open )
  (void ra:show-home-help-window )
  (void ra:show-chance-help-window )
  (void ra:show-velocity-help-window )
  (void ra:show-fx-text-help-window )
  (void ra:show-swing-help-window )
  (void ra:show-mixer-help-window )
  (void ra:show-keybindings-help-window )
  (void ra:show-bpm-text-help-window )
  (void ra:show-lpb-text-help-window )
  (void ra:show-signature-text-help-window )
  (void ra:show-lz-track-help-window )
  (void ra:show-tempo-automation-track-help-window )
  (void ra:ensure-clean-state-outside-mouse-cycle )
  (void ra:cancel-current-node )
  (void ra:cancel-indicator-node )
  (Place ra:get-place-from-y (float y ) (int blocknum -1) (int windownum -1) )
  (Place ra:get-place-in-grid-from-y (float y ) (int blocknum -1) (int windownum -1) )
  (Place ra:get-next-place-in-grid-from-y (float y ) (int blocknum -1) (int windownum -1) )
  (float ra:get-y-from-place (Place place ) (int blocknum -1) (int windownum -1) )
  (Place ra:get-place-from-realline (int realline ) (int blocknum -1) (int windownum -1) )
  (float ra:get-realline-y1 (int realline ) (int blocknum -1) (int windownum -1) )
  (float ra:get-realline-y2 (int realline ) (int blocknum -1) (int windownum -1) )
  (int ra:get-realline-from-y (float y ) (int blocknum -1) (int windownum -1) )
  (int ra:get-top-realline (int blocknum -1) (int windownum -1) )
  (int ra:get-bot-realline (int blocknum -1) (int windownum -1) )
  (float ra:get-half-of-node-width )
  (float ra:get-top-visible-y (int blocknum -1) (int windownum -1) )
  (float ra:get-bot-visible-y (int blocknum -1) (int windownum -1) )
  (void ra:set-no-mouse-track )
  (void ra:set-mouse-track-to-reltempo )
  (void ra:set-mouse-track (int tracknum ) )
  (float ra:get-editor-x1 (int windownum -1) )
  (float ra:get-editor-x2 (int windownum -1) )
  (float ra:get-editor-y1 (int windownum -1) )
  (float ra:get-editor-y2 (int windownum -1) )
  (float ra:get-block-header-y2 (int blocknum -1) (int windownum -1) )
  (float ra:get-track-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-beat-bar-border-x (int blocknum -1) (int windownum -1) )
  (int ra:get-tempo-visualizer-tracknum )
  (int ra:get-bpm-tracknum )
  (int ra:get-lpb-tracknum )
  (int ra:get-signature-tracknum )
  (int ra:get-linenum-tracknum )
  (int ra:get-beat-tracknum )
  (int ra:get-swing-tracknum )
  (int ra:get-tempo-automation-tracknum )
  (float ra:get-track-pianoroll-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-pianoroll-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-pianoroll-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-pianoroll-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-notes-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-notes-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-notes-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-notes-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-fx-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-fx-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-fx-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-fx-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-centtext-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-centtext-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-centtext-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-centtext-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-chancetext-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-chancetext-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-chancetext-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-chancetext-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-swingtext-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-swingtext-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-swingtext-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-swingtext-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-velocitytext-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-velocitytext-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-velocitytext-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-velocitytext-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fxtext-x1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fxtext-y1 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fxtext-x2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fxtext-y2 (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-fxtext-fxnum-from-x (float x ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-leftmost-track-num )
  (int ra:get-rel-tempo-track-num )
  (int ra:get-tempo-track-num )
  (int ra:get-lpb-track-num )
  (int ra:get-signature-track-num )
  (int ra:get-swing-track-num )
  (int ra:get-tempo-color-track-num )
  (int ra:get-linenum-track-num )
  (float ra:get-reltempo-slider-x1 )
  (float ra:get-reltempo-slider-y1 )
  (float ra:get-reltempo-slider-x2 )
  (float ra:get-reltempo-slider-y2 )
  (double ra:get-reltempo (int blocknum -1) (int windownum -1) )
  (void ra:undo-reltempo (int blocknum -1) (int windownum -1) )
  (void ra:set-reltempo (double reltempo ) (int blocknum -1) (int windownum -1) )
  (float ra:get-min-reltempo )
  (float ra:get-max-reltempo )
  (void ra:add-block-multiplier-midi-learn )
  (void ra:remove-block-multiplier-midi-learn )
  (bool ra:has-block-multiplier-midi-learn )
  (float ra:get-track-slider-x1 (int blocknum -1) (int windownum -1) )
  (float ra:get-track-slider-y1 (int blocknum -1) (int windownum -1) )
  (float ra:get-track-slider-x2 (int blocknum -1) (int windownum -1) )
  (float ra:get-track-slider-y2 (int blocknum -1) (int windownum -1) )
  (void ra:set-track-slider-is-moving (bool is_moving ) (int windownum -1) )
  (bool ra:get-track-slider-is-moving (int windownum -1) )
  (float ra:get-editor-scrollbar-x1 )
  (float ra:get-editor-scrollbar-y1 )
  (float ra:get-editor-scrollbar-x2 )
  (float ra:get-editor-scrollbar-y2 )
  (float ra:get-editor-scrollbar-scroller-x1 )
  (float ra:get-editor-scrollbar-scroller-y1 (int blocknum -1) (int windownum -1) )
  (float ra:get-editor-scrollbar-scroller-x2 )
  (float ra:get-editor-scrollbar-scroller-y2 (int blocknum -1) (int windownum -1) )
  (float ra:get-track-slider-pos (int blocknum -1) (int windownum -1) )
  (void ra:set-track-slider-pos (float pos ) (int blocknum -1) (int windownum -1) )
  (void ra:set-editor-scrollbar-is-moving (bool is_moving ) (int windownum -1) )
  (bool ra:get-track-pan-on-off (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-pan-on-off (bool onoff ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:switch-track-pan-on-off (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:get-track-volume-on-off (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-track-volume-on-off (bool onoff ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:switch-track-volume-on-off (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-pan (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:undo-track-pan (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-volume (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:undo-track-volume (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-temponode-area-x1 )
  (int ra:get-temponode-area-y1 )
  (int ra:get-temponode-area-x2 )
  (int ra:get-temponode-area-y2 )
  (float ra:get-temponode-max (int blocknum -1) (int windownum -1) )
  (float ra:get-temponode-x (int num ) )
  (float ra:get-temponode-y (int num ) )
  (Place ra:get-temponode-place (int num ) (int blocknum -1) (int windownum -1) )
  (float ra:get-temponode-value (int num ) (int blocknum -1) (int windownum -1) )
  (void ra:set-current-temponode (int num ) (int blocknum -1) )
  (void ra:set-indicator-temponode (int num ) (int blocknum -1) )
  (int ra:get-pioanoroll-low-key (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-pioanoroll-high-key (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pianonote-x1 (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pianonote-y1 (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pianonote-x2 (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pianonote-y2 (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pianonote-value (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (Place ra:get-pianonote-place (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-pianonote-logtype (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-pianonote-logtype (int logtype ) (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-num-pianonotes (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-current-pianonote (int num ) (dyn_t note ) (int tracknum ) )
  (dyn_t ra:get-current-pianonote (int tracknum ) )
  (void ra:cancel-current-pianonote )
  (void ra:set-current-piano-ghost-note (Place place_start ) (Place place_end ) (float value ) (int tracknum -1) )
  (void ra:cancel-current-piano-ghost-note )
  (bool ra:has-current-piano-ghost-note-start )
  (int ra:get-current-piano-ghost-note-tracknum )
  (Place ra:get-current-piano-ghost-note-start )
  (Place ra:get-current-piano-ghost-note-end )
  (float ra:get-current-piano-ghost-note-value )
  (void ra:add-pianonote-pitch (float value ) (Place place ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:show-pianoroll-eraser (float pitch1 ) (float pitch2 ) (Place place1 ) (Place place2 ) (int tracknum ) (int blocknum -1) (int windownum -1) )
  (void ra:hide-pianoroll-eraser (int windownum -1) )
  (void ra:show-pianoroll-selection-rectangle (float pitch1 ) (float pitch2 ) (Place place1 ) (Place place2 ) (int tracknum ) (int blocknum -1) (int windownum -1) )
  (void ra:hide-pianoroll-selection-rectangle (int windownum -1) )
  (void ra:copy-selected-pianonotes (int tracknum -1) (int blocknum -1) )
  (void ra:cut-selected-pianonotes (int tracknum -1) (int blocknum -1) )
  (void ra:delete-selected-pianonotes (int tracknum -1) (int blocknum -1) )
  (void ra:paste-pianonotes (float pitch getCurrentPianoGhostNoteValue()) (Place start_place getCurrentPianoGhostNoteStart()) (int tracknum getCurrentPianoGhostNoteTracknum()) (int blocknum -1) )
  (dyn_t ra:move-pianonote (int pianonotenum ) (float value ) (Place place ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:move-pianonote-start (int pianonotenum ) (float value ) (Place place ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:move-pianonote-end (int pianonotenum ) (float value ) (Place place ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:add-pianonote (float value ) (Place place ) (Place endplace ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-pianonote (int pianonotenum ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:placetest (Place dasplacevar ) (int windownum -1) )
  (Place ra:placetest2 (int a ) (int b ) (int c ) )
  (void ra:set-current-bar (int barnum ) (int blocknum -1) )
  (void ra:set-current-beat (int barnum ) (int beatnum ) (int blocknum -1) )
  (dyn_t ra:get-current-bar )
  (dyn_t ra:get-current-beat )
  (void ra:cancel-current-beat )
  (dyn_t ra:get-beat-at-realline (int realline ) (int blocknum -1) (int windownum -1) )
  (dyn_t ra:get-beat-at-place (Place place ) (int blocknum -1) (int windownum -1) )
  (dynvec_t ra:get-beats (int startline 0) (int endline -1) (int blocknum -1) (int windownum -1) )
  (Place ra:get-beat-start (int barnum -1) (int beatnum -1) (int blocknum -1) )
  (Place ra:get-beat-end (int barnum -1) (int beatnum -1) (int blocknum -1) )
  (Place ra:get-bar-start (int barnum -1) (int blocknum -1) )
  (Place ra:get-bar-end (int barnum -1) (int blocknum -1) )
  (bool ra:has-beat (int barnum -1) (int beatnum -1) (int blocknum -1) )
  (int ra:get-num-pitchnums (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitchnum-x1 (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitchnum-y1 (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitchnum-x2 (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitchnum-y2 (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitchnum-x (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitchnum-y (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-pitchnum-value (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (Place ra:get-pitchnum-place (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-current-pitchnum (int num ) (int tracknum -1) (int blocknum -1) )
  (void ra:set-indicator-pitchnum (int num ) (int tracknum -1) (int blocknum -1) )
  (int ra:set-pitchnum (int num ) (float value ) (Place place ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-pitchnum (int pitchnum ) (int tracknum -1) (int blocknum -1) )
  (int ra:add-pitchnum (float value ) (Place place ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-pitchnum-f (float value ) (float place ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-pitchnum-logtype (int logtype ) (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-notenum-for-pitchnum (int pitchnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:portamento-enabled (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-note-end-pitch (float value ) (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:enable-portamento (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:disable-portamento (dyn_t note ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-subtrack-x1 (int subtracknum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-subtrack-x2 (int subtracknum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-fx (const_char* fx_name ) (int tracknum -1) (instrument_t instrument_id createIllegalInstrument()) (int blocknum -1) (int windownum -1) )
  (int ra:add-fx (float value ) (Place place ) (const_char* fx_name ) (int tracknum -1) (instrument_t instrument_id createIllegalInstrument()) (int blocknum -1) (int windownum -1) )
  (int ra:add-fx-f (float value ) (float place ) (const_char* fx_name ) (int tracknum -1) (instrument_t instrument_id createIllegalInstrument()) (int blocknum -1) (int windownum -1) )
  (int ra:add-fxnode (float value ) (Place place ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:add-fxnode-f (float value ) (float floatplace ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-fxnode (int fxnodenum ) (float value ) (Place place ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-fxnode-f (int fxnodenum ) (float value ) (float place ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-fxnode-logtype (int logtype ) (int fxnodenum ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:delete-fxnode (int fxnodenum ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (Place ra:get-fxnode-place (int fxnodenum ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fxnode-value (int num ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-fxnode-logtype (int num ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:get-fx-enabled (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-fx-enabled (bool is_enabled ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:request-fx (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fxnode-x (int num ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fxnode-y (int num ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (const_char* ra:get-fx-name (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (instrument_t ra:get-fx-instrument (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (const_char* ra:get-fx-string (int fxnodenum ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-num-fxs (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-num-fxnodes (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fx-min-value (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-fx-max-value (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-current-fxnode (int fxnodenum ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-indicator-fxnode (int fxnodenum ) (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:set-no-mouse-fx (int blocknum -1) (int windownum -1) )
  (void ra:set-mouse-fx (int fxnum ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (int ra:get-mouse-fx (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:undo-fxs (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:clear-track-fx (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (float ra:get-track-width (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (void ra:undo-track-width )
  (void ra:set-track-width (float new_width ) (int tracknum -1) (int blocknum -1) (int windownum -1) )
  (bool ra:control-pressed )
  (bool ra:horizontal-modifier-pressed )
  (bool ra:vertical-modifier-pressed )
  (bool ra:shift-pressed )
  (bool ra:meta-pressed )
  (bool ra:alt-pressed )
  (void ra:set-normal-mouse-pointer (int64_t guinum ) )
  (void ra:set-pointing-mouse-pointer (int64_t guinum ) )
  (void ra:set-open-hand-mouse-pointer (int64_t guinum ) )
  (void ra:set-closed-hand-mouse-pointer (int64_t guinum ) )
  (void ra:set-blank-mouse-pointer (int64_t guinum ) )
  (void ra:set-diagonal-resize-mouse-pointer (int64_t guinum ) )
  (void ra:set-vertical-resize-mouse-pointer (int64_t guinum ) )
  (void ra:set-horizontal-resize-mouse-pointer (int64_t guinum ) )
  (void ra:set-vertical-split-mouse-pointer (int64_t guinum ) )
  (void ra:set-horizontal-split-mouse-pointer (int64_t guinum ) )
  (void ra:move-mouse-pointer (float x ) (float y ) (int windownum -1) )
  (void ra:move-abs-mouse-pointer (float x ) (float y ) (int windownum -1) )
  (bool ra:is-left-mouse-pressed )
  (bool ra:is-right-mouse-pressed )
  (bool ra:is-middle-mouse-pressed )
  (double ra:get-double-click-interval )
  (float ra:get-mouse-pointer-x (int windownum -1) )
  (float ra:get-mouse-pointer-y (int windownum -1) )
  (float ra:get-delta-mouse-x )
  (float ra:get-delta-mouse-y )
  (bool ra:has-delta-mouse )
  (bool ra:can-move-pointer )
  (float ra:get-global-mouse-pointer-x )
  (float ra:get-global-mouse-pointer-y )
  (float ra:get-abs-mouse-pointer-x (int windownum -1) )
  (float ra:get-abs-mouse-pointer-y (int windownum -1) )
  (int ra:get-screen-width (int windownum -1) )
  (int ra:get-screen-height (int windownum -1) )
  (bool ra:mouse-pointer-in-mixer )
  (float ra:get-sequencer-x1 )
  (float ra:get-sequencer-x2 )
  (float ra:get-sequencer-y1 )
  (float ra:get-sequencer-y2 )
  (float ra:get-seqtracks-x1 )
  (float ra:get-seqtracks-x2 )
  (float ra:get-seqtracks-y1 )
  (float ra:get-seqtracks-y2 )
  (float ra:get-sequencer-left-part-x1 )
  (float ra:get-sequencer-left-part-x2 )
  (float ra:get-sequencer-left-part-y1 )
  (float ra:get-sequencer-left-part-y2 )
  (float ra:get-sequencer-left-part-buttons-y1 )
  (bool ra:get-sequencer-right-part-empty )
  (void ra:set-sequencer-right-part-empty (bool is_empty ) )
  (float ra:get-sequencer-right-part-x1 )
  (float ra:get-sequencer-right-part-x2 )
  (float ra:get-sequencer-right-part-y1 )
  (float ra:get-sequencer-right-part-y2 )
  (void ra:undo-seqblock-fades (int seqblocknum ) (int seqtracknum ) )
  (void ra:undo-seqtrack-automations )
  (void ra:undo-seqblock-automation (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:undo-seqblock (int seqblocknum ) (int seqtracknum ) )
  (void ra:undo-sequencer )
  (int64_t ra:get-sequencer-song-length-in-frames )
  (int64_t ra:get-sequencer-visible-start-time )
  (int64_t ra:get-sequencer-visible-end-time )
  (void ra:set-sequencer-visible-start-time (int64_t value ) )
  (void ra:set-sequencer-visible-end-time (int64_t value ) )
  (void ra:set-sequencer-selection-rectangle (float x1 ) (float y1 ) (float x2 ) (float y2 ) )
  (void ra:unset-sequencer-selection-rectangle )
  (float ra:get-seqnav-x1 )
  (float ra:get-seqnav-x2 )
  (float ra:get-seqnav-y1 )
  (float ra:get-seqnav-y2 )
  (float ra:get-seqnav-left-size-handle-x1 )
  (float ra:get-seqnav-left-size-handle-x2 )
  (float ra:get-seqnav-left-size-handle-y1 )
  (float ra:get-seqnav-left-size-handle-y2 )
  (float ra:get-seqnav-right-size-handle-x1 )
  (float ra:get-seqnav-right-size-handle-x2 )
  (float ra:get-seqnav-right-size-handle-y1 )
  (float ra:get-seqnav-right-size-handle-y2 )
  (void ra:set-seqtrack-is-recording (int seqtracknum ) (bool is_recording ) )
  (bool ra:seqtrack-is-recording (int seqtracknum ) (bool throw_error_if_seqtrack_is_not_for_audio true) )
  (void ra:set-seqtrack-use-custom-recording-config (int seqtracknum ) (bool use_custom ) )
  (bool ra:get-seqtrack-use-custom-recording-config (int seqtracknum ) )
  (void ra:set-seqtrack-record-from-system-input (int seqtracknum ) (bool record_from_system_input ) )
  (bool ra:get-seqtrack-record-from-system-input (int seqtracknum ) )
  (void ra:set-seqtrack-record-compensate-latency (int seqtracknum ) (bool compensate_latency ) )
  (bool ra:get-seqtrack-record-compensate-latency (int seqtracknum ) )
  (void ra:set-seqtrack-recording-matrix (int seqtracknum ) (int input_channel ) (int soundfile_channel ) (bool enabled ) )
  (bool ra:get-seqtrack-recording-matrix (int seqtracknum ) (int input_channel ) (int soundfile_channel ) )
  (void ra:reset-seqtrack-recording-options (int seqtracknum ) )
  (int ra:add-seq-automation (int64_t time1 ) (float value1 ) (int64_t time2 ) (float value2 ) (int effect_num ) (instrument_t instrument_id ) (int seqtracknum ) )
  (dyn_t ra:add-seq-automation2 (int64_t time1 ) (float value1 ) (int64_t time2 ) (float value2 ) (int effect_num ) (instrument_t instrument_id ) (int seqtracknum ) )
  (void ra:replace-all-seq-automation (instrument_t old_instrument ) (instrument_t new_instrument ) )
  (int ra:get-num-seqtrack-automations (int seqtracknum ) )
  (bool ra:get-seq-automation-enabled (int automationnum ) (int seqtracknum ) )
  (void ra:set-seq-automation-enabled (int automationnum ) (int seqtracknum ) (bool is_enabled ) )
  (instrument_t ra:get-seq-automation-instrument-id (int automationnum ) (int seqtracknum ) )
  (int ra:get-seq-automation-effect-num (int automationnum ) (int seqtracknum ) )
  (const_char* ra:get-seq-automation-color (int automationnum ) (int seqtracknum ) )
  (float ra:get-seq-automation-value (int nodenum ) (int automationnum ) (int seqtracknum ) )
  (int64_t ra:get-seq-automation-time (int nodenum ) (int automationnum ) (int seqtracknum ) )
  (int ra:get-seq-automation-logtype (int nodenum ) (int automationnum ) (int seqtracknum ) )
  (int ra:get-num-seqtrack-automation-nodes (int automationnum ) (int seqtracknum ) )
  (int ra:add-seq-automation-node (int64_t time ) (float value ) (int logtype ) (int automationnum ) (int seqtracknum ) )
  (void ra:delete-seq-automation-node (int nodenum ) (int automationnum ) (int seqtracknum ) )
  (void ra:set-curr-seq-automation-node (int nodenum ) (int automationnum ) (int seqtracknum ) )
  (void ra:cancel-curr-seq-automation-node (int automationnum ) (int seqtracknum ) )
  (void ra:set-curr-seq-automation (int automationnum ) (int seqtracknum ) )
  (void ra:cancel-curr-seq-automation )
  (int ra:get-curr-seq-automation-seqtrack )
  (int ra:get-curr-seq-automation )
  (void ra:set-seq-automation-node (int64_t time ) (float value ) (int logtype ) (int nodenum ) (int automationnum ) (int seqtracknum ) )
  (float ra:get-seq-automation-node-x (int nodenum ) (int automationnum ) (int seqtracknum ) )
  (float ra:get-seq-automation-node-y (int nodenum ) (int automationnum ) (int seqtracknum ) )
  (void ra:set-seqblock-gain (float new_gain ) (int64_t seqblockid ) )
  (float ra:get-seqblock-gain (int64_t seqblockid ) )
  (float ra:get-max-seqblock-sample-gain (int64_t seqblockid ) )
  (void ra:set-seqblock-grain-strict-no-jitter (bool new_strict_no_jitter ) (int64_t seqblockid ) )
  (bool ra:get-seqblock-grain-strict-no-jitter (int64_t seqblockid ) )
  (void ra:set-seqblock-grain-overlap (double new_gf ) (int64_t seqblockid ) )
  (double ra:get-seqblock-grain-overlap (int64_t seqblockid ) )
  (void ra:set-seqblock-grain-length (double new_gf ) (int64_t seqblockid ) )
  (double ra:get-seqblock-grain-length (int64_t seqblockid ) )
  (void ra:set-seqblock-grain-jitter (double new_jitter ) (int64_t seqblockid ) )
  (double ra:get-seqblock-grain-jitter (int64_t seqblockid ) )
  (void ra:set-seqblock-grain-ramp (double new_ramp ) (int64_t seqblockid ) )
  (double ra:get-seqblock-grain-ramp (int64_t seqblockid ) )
  (int ra:get-seqblock-resampler-type (int64_t seqblockid ) )
  (int ra:get-num-seqblock-automations (int seqblocknum ) (int seqtracknum ) )
  (const_char* ra:get-seqblock-automation-name (int automationnum ) )
  (const_char* ra:get-seqblock-automation-color (int automationnum ) )
  (bool ra:get-seqblock-automation-enabled (int automationnum ) (int64_t seqblockid ) )
  (void ra:set-seqblock-automation-enabled (bool is_enabled ) (int automationnum ) (int64_t seqblockid ) )
  (double ra:get-seqblock-automation-min-value (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (double ra:get-seqblock-automation-max-value (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (double ra:get-seqblock-automation-default-value (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (const_char* ra:get-seqblock-automation-display-string (double value ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-automation-value (int nodenum ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-automation-value-for-time (int64_t time ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (int64_t ra:get-seqblock-automation-time (int nodenum ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (int ra:get-seqblock-automation-logtype (int nodenum ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (int ra:get-num-seqblock-automation-nodes (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (int ra:add-seqblock-automation-node (int64_t time ) (float value ) (int logtype ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:delete-seqblock-automation-node (int nodenum ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:set-curr-seqblock-automation-node (int nodenum ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:cancel-curr-seqblock-automation-node (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:set-curr-seqblock-automation (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:cancel-curr-seqblock-automation )
  (void ra:set-seqblock-automation-node (int64_t time ) (float value ) (int logtype ) (int nodenum ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-automation-node-x (int nodenum ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-automation-node-y (int nodenum ) (int automationnum ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:undo-seqtempo )
  (float ra:get-seqtempo-area-x1 )
  (float ra:get-seqtempo-area-y1 )
  (float ra:get-seqtempo-area-x2 )
  (float ra:get-seqtempo-area-y2 )
  (float ra:get-seqtemponode-x (int nodenum ) )
  (float ra:get-seqtemponode-y (int nodenum ) )
  (void ra:set-seqtempo-visible (bool visible ) )
  (bool ra:seqtempo-visible )
  (double ra:get-seqtempo-value (int nodenum ) )
  (double ra:get-seqtempo-abstime (int nodenum ) )
  (int ra:get-seqtempo-logtype (int nodenum ) )
  (int ra:get-num-seqtemponodes )
  (int ra:add-seqtemponode (double abstime ) (double value ) (int logtype ) )
  (void ra:delete-seqtemponode (int nodenum ) )
  (void ra:set-curr-seqtemponode (int nodenum ) )
  (void ra:set-seqtemponode (double abstime ) (double value ) (int logtype ) (int nodenum ) )
  (void ra:set-seqtempo-length (double end_time ) (bool do_shrink false) )
  (double ra:get-seqtempo-length )
  (int64_t ra:get-seqtempo-absabstime (double abstime ) )
  (double ra:get-seqtempo-max-tempo )
  (void ra:set-seqtempo-max-tempo (double max_tempo ) )
  (float ra:get-seqtimeline-area-x1 )
  (float ra:get-seqtimeline-area-y1 )
  (float ra:get-seqtimeline-area-x2 )
  (float ra:get-seqtimeline-area-y2 )
  (void ra:set-seq-indicator (int64_t indicator_x_pos ) (double indicator_y -1) (int type 0) (const_char* color "") )
  (void ra:cancel-seq-indicator )
  (bool ra:seq-indicator-enabled )
  (int64_t ra:get-seq-indicator-x-pos )
  (double ra:get-seq-indicator-y )
  (int ra:get-seq-indicator-type )
  (void ra:set-seqlooping (bool do_loop ) (int64_t start -1) (int64_t end -1) )
  (bool ra:is-seqlooping )
  (void ra:set-seqlooping-start (int64_t start ) )
  (int64_t ra:get-seqlooping-start )
  (void ra:set-seqlooping-end (int64_t end ) )
  (int64_t ra:get-seqlooping-end )
  (void ra:set-seqpunching (bool do_loop ) )
  (bool ra:is-seqpunching )
  (void ra:set-seqpunching-start (int64_t start ) )
  (int64_t ra:get-seqpunching-start )
  (void ra:set-seqpunching-end (int64_t end ) )
  (int64_t ra:get-seqpunching-end )
  (void ra:insert-seqtrack-internal (bool for_audiofiles ) (int pos ) (bool is_bus ) )
  (void ra:insert-seqtrack (bool for_audiofiles ) (int pos -1) (bool is_bus false) (bool force_insert false) )
  (void ra:insert-editor-seqtrack (int pos -1) (bool force_insert false) )
  (void ra:insert-audio-seqtrack (int pos -1) (bool force_insert false) )
  (void ra:insert-bus-seqtrack (int pos -1) (bool force_insert false) )
  (int ra:append-seqtrack (bool for_audiofiles ) (bool is_bus false) )
  (int ra:append-editor-seqtrack )
  (int ra:append-audio-seqtrack )
  (int ra:append-bus-seqtrack )
  (bool ra:seqtrack-is-permanent (int seqtracknum -1) )
  (bool ra:seqtrack-is-bus (int seqtracknum -1) )
  (void ra:delete-seqtrack (int seqtracknum -1) )
  (void ra:force-delete-seqtrack (int seqtracknum -1) )
  (int ra:get-num-selected-seqblocks )
  (void ra:set-curr-seqtrack (int seqtracknum ) (bool auto_scroll_to_make_seqtrack_visible true) (bool change_curr_instrument false) )
  (void ra:set-curr-seqtrack-down (int num_seqtracks ) (bool auto_scroll_to_make_seqtrack_visible true) )
  (void ra:set-curr-seqtrack-up (int num_seqtracks ) (bool auto_scroll_to_make_seqtrack_visible true) )
  (int ra:get-curr-seqtrack )
  (int ra:get-num-seqtracks )
  (int ra:get-lowest-visible-seqtrack (bool must_be_fully_visible false) )
  (int ra:get-topmost-visible-seqtrack )
  (void ra:set-topmost-visible-seqtrack (int new_topmost ) )
  (void ra:autoscroll-seqtracks (int seqtracknum ) (bool make_fully_visible false) )
  (int ra:get-lowest-possible-topmost-visible-seqtrack )
  (void ra:move-seqtrack (int seqtracknum ) (int new_pos ) )
  (void ra:swap-seqtracks (int seqtracknum1 ) (int seqtracknum2 ) )
  (instrument_t ra:get-seqtrack-instrument (int seqtracknum ) )
  (bool ra:seqtrack-for-audiofiles (int seqtracknum ) )
  (void ra:set-seqtrack-name (const_char* name ) (int seqtracknum ) )
  (const_char* ra:get-seqtrack-name (int seqtracknum ) )
  (void ra:set-seqtrack-visible (int seqtracknum ) (bool is_visible ) )
  (bool ra:get-seqtrack-visible (int seqtracknum ) )
  (void ra:set-seqtracks-visible (dynvec_t seqtracknums ) (bool is_visible ) )
  (const_char* ra:get-seqtrack-uuid (int seqtracknum ) )
  (void ra:set-curr-seqtrack-config-num (int num ) )
  (int ra:get-curr-seqtrack-config-num )
  (bool ra:seqtrack-config-is-used (int num ) )
  (void ra:reset-seqtrack-config )
  (void ra:undo-seqtrack-note-gain (int seqtracknum ) )
  (void ra:set-seqtrack-note-gain (float gain ) (int seqtracknum ) )
  (float ra:get-seqtrack-note-gain (int seqtracknum ) )
  (void ra:set-editor-seqtrack-muted (bool muteit ) (int seqtracknum ) )
  (bool ra:get-editor-seqtrack-muted (int seqtracknum ) )
  (bool ra:get-seqtrack-mute (int seqtracknum -1) )
  (void ra:set-seqtrack-mute (bool do_mute ) (int seqtracknum -1) )
  (bool ra:switch-seqtrack-mute (int seqtracknum -1) )
  (bool ra:get-seqtrack-solo (int seqtracknum -1) )
  (void ra:set-seqtrack-solo (bool do_solo ) (int seqtracknum -1) )
  (bool ra:switch-seqtrack-solo (int seqtracknum -1) )
  (float ra:get-seqtrack-x1 (int seqtracknum ) )
  (float ra:get-seqtrack-x2 (int seqtracknum ) )
  (float ra:get-seqtrack-y1 (int seqtracknum ) )
  (float ra:get-seqtrack-y2 (int seqtracknum ) )
  (int ra:get-seqtrack-from-y (int y ) )
  (double ra:get-seqtrack-border-width )
  (int ra:get-seqtrack-min-height-type (int seqtracknum -1) )
  (void ra:set-seqtrack-min-height-type (int new_type ) (int seqtracknum -1) )
  (int ra:get-seqtrack-max-height-type (int seqtracknum -1) )
  (void ra:set-seqtrack-max-height-type (int new_type ) (int seqtracknum -1) )
  (void ra:set-sequencer-grid-type (const_char* grid_type ) )
  (const_char* ra:get-sequencer-grid-type )
  (bool ra:sequencer-grid-enabled )
  (void ra:set-sequencer-grid-enabled (bool val ) )
  (bool ra:switch-sequencer-grid-enabled )
  (void ra:set-paint-sequencer-grid (bool doit ) )
  (int64_t ra:get-seq-gridded-time (int64_t pos ) (const_char* grid_type "current") )
  (int64_t ra:find-closest-seqtrack-bar-start (int seqtracknum ) (int64_t pos ) )
  (int64_t ra:find-closest-seqtrack-beat-start (int seqtracknum ) (int64_t pos ) )
  (int64_t ra:find-closest-seqtrack-line-start (int seqtracknum ) (int64_t pos ) )
  (void ra:insert-silence-to-seqtrack (int seqtracknum ) (int64_t pos ) (int64_t duration ) )
  (void ra:playlist-insert )
  (void ra:playlist-remove )
  (void ra:playlist-up )
  (void ra:playlist-down )
  (int ra:get-curr-blocklist-pos )
  (void ra:set-curr-blocklist-pos (int pos ) )
  (int ra:get-curr-playlist-pos )
  (void ra:set-curr-playlist-pos (int new_pos ) (bool also_set_curr_seqblock true) (bool also_set_new_song_pos true) )
  (void ra:lock-curr-playlist-pos-to-curr-seqblock (bool doit ) )
  (int64_t ra:get-playlist-pos-time (int pos -1) )
  (int ra:create-seqblock (int seqtracknum -1) (int blocknum -1) (int64_t pos -1) (int64_t endpos -1) )
  (int ra:create-sample-seqblock (int seqtracknum ) (filepath_t w_filename ) (int64_t pos -1) (int64_t endpos -1) )
  (const_char* ra:get-audiofile-postfixes )
  (bool ra:add-audiofile (filepath_t w_filename ) )
  (int64_t ra:get-audio-files-generation )
  (dynvec_t ra:get-audio-files )
  (int ra:create-gfx-gfx-seqblock (dyn_t state ) )
  (int ra:create-seqblock-from-state (dyn_t state ) )
  (dyn_t ra:get-seqblock-state (int seqblocknum ) (int seqtracknum ) )
  (int ra:get-playlist-pos-for-seqblock (int64_t seqblockid ) )
  (void ra:set-curr-seqblock (int64_t seqblockid ) )
  (int64_t ra:get-curr-seqblock-id )
  (void ra:cancel-curr-seqblock )
  (void ra:select-next-seqblock )
  (void ra:select-prev-seqblock )
  (void ra:set-curr-seqblock-under-mouse (int64_t seqblockid ) )
  (int64_t ra:get-curr-seqblock-id-under-mouse )
  (void ra:cancel-curr-seqblock-under-mouse )
  (int ra:get-curr-seqblock-under-mouse )
  (int ra:get-curr-seqtrack-under-mouse (bool forgiving true) (bool only_inside_timeline false) )
  (void ra:set-curr-seqtrack-under-mouse (int seqtracknum ) )
  (void ra:set-curr-editor-block-under-mouse-for-sequencer (int blocknum ) )
  (int ra:get-curr-editor-block-under-mouse-for-sequencer )
  (void ra:set-curr-sample-under-mouse-for-sequencer (filepath_t filepath ) )
  (filepath_t ra:get-curr-sample-under-mouse-for-sequencer )
  (bool ra:seqblock-is-alive (int64_t seqblockid ) )
  (dyn_t ra:get-seqblocks-state (int seqtracknum ) )
  (dyn_t ra:get-gfx-seqblocks-state (int seqtracknum ) )
  (void ra:create-gfx-seqblocks-from-state (dyn_t seqblocks_state ) (int seqtracknum ) )
  (void ra:cancel-gfx-seqblocks (int seqtracknum ) )
  (void ra:apply-gfx-seqblocks (int seqtracknum ) )
  (dynvec_t ra:get-block-usage-in-sequencer )
  (void ra:set-seqblock-name (const_char* new_name ) (int64_t seqblockid ) (bool name_is_base64 true) )
  (const_char* ra:get-seqblock-name (int64_t seqblockid ) )
  (int ra:get-num-seqblocks (int seqtracknum ) )
  (int ra:get-num-gfx-gfx-seqblocks (int seqtracknum ) )
  (int64_t ra:get-seqblock-start-time (int seqblocknum ) (int seqtracknum ) (bool use_gfx_if_possible false) )
  (int64_t ra:get-seqblock-end-time (int seqblocknum ) (int seqtracknum ) (bool use_gfx_if_possible false) )
  (int64_t ra:get-seqblock-default-duration (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-y2 (int seqblocknum ) (int seqtracknum ) )
  (void ra:set-seqblock-selected-box (int which_one ) (int seqblocknum ) (int seqtracknum ) )
  (int ra:get-seqblock-selected-box )
  (float ra:get-seqblock-header-y2 (int seqblocknum ) (int seqtracknum ) )
  (const_char* ra:get-seqblock-color (int64_t seqblockid ) )
  (float ra:get-seqblock-left-fade-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-fade-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-fade-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-fade-y2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-fade-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-fade-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-fade-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-fade-y2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-interior-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-interior-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-interior-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-interior-y2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-interior-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-interior-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-interior-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-interior-y2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-speed-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-speed-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-speed-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-speed-y2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-speed-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-speed-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-speed-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-speed-y2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-stretch-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-stretch-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-stretch-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-left-stretch-y2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-stretch-x1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-stretch-y1 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-stretch-x2 (int seqblocknum ) (int seqtracknum ) )
  (float ra:get-seqblock-right-stretch-y2 (int seqblocknum ) (int seqtracknum ) )
  (double ra:get-seqblock-fade-in (int seqblocknum ) (int seqtracknum ) )
  (double ra:get-seqblock-fade-out (int seqblocknum ) (int seqtracknum ) )
  (void ra:set-seqblock-fade-in (double fadein ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:set-seqblock-fade-out (double fadeout ) (int seqblocknum ) (int seqtracknum ) )
  (dynvec_t ra:get-fade-shapes )
  (const_char* ra:get-fade-shape-icon-filename (const_char* shape ) (bool is_fadein ) )
  (const_char* ra:get-seqblock-fade-shape (bool is_fadein ) (int seqblocknum ) (int seqtracknum ) )
  (bool ra:set-seqblock-fade-shape (const_char* shape ) (bool is_fadein ) (int seqblocknum ) (int seqtracknum ) )
  (void ra:delete-seqblock (int64_t seqblockid -1) (bool notify_listeners true) )
  (void ra:delete-gfx-gfx-seqblock (int seqblocknum ) (int seqtracknum ) )
  (int ra:get-seqblock-blocknum (int seqblocknum ) (int seqtracknum ) )
  (filepath_t ra:get-seqblock-sample (int seqblocknum ) (int seqtracknum ) )
  (int64_t ra:get-sample-length (filepath_t w_sample ) )
  (void ra:select-seqblock (bool is_selected ) (int seqblocknum ) (int seqtracknum -1) )
  (bool ra:is-seqblock-selected (int seqblocknum ) (int seqtracknum -1) )
  (void ra:generate-new-color-for-all-selected-seqblocks (float mix_background 1.0) )
  (void ra:unset-all-selected-seqblocks )
  (bool ra:is-seqblock-track-enabled (int tracknum ) (int seqblocknum ) (int seqtracknum -1) )
  (void ra:set-seqblock-track-enabled (bool is_enabled ) (int tracknum ) (int seqblocknum ) (int seqtracknum -1) )
  (void ra:copy-editor-track-on-off-to-seqblock (int seqblocknum -1) (int seqtracknum -1) )
  (void ra:copy-seqblock-track-on-off-to-editor (int seqblocknum -1) (int seqtracknum -1) )
  (bool ra:seqblock-holds-block (int seqblocknum ) (int seqtracknum ) (bool use_gfx_if_possible false) )
  (bool ra:seqblock-holds-sample (int seqblocknum ) (int seqtracknum ) (bool use_gfx_if_possible false) )
  (double ra:get-seqblock-stretch (int64_t seqblockid ) (bool use_gfx_if_possible false) )
  (double ra:get-seqblock-speed (int64_t seqblockid ) (bool use_gfx_if_possible false) )
  (double ra:get-seqblock-stretch-speed (int64_t seqblockid ) (bool use_gfx_if_possible false) )
  (double ra:get-seqblock-resample-ratio (int64_t seqblockid ) (bool use_gfx_if_possible false) )
  (int64_t ra:get-seqblock-id (int seqblocknum ) (int seqtracknum ) )
  (int ra:get-seqblock-seqtrack-num (int64_t seqblockid ) )
  (int ra:get-seqblock-seqblock-num (int64_t seqblockid ) )
  (void ra:add-seqblock-deleted-callback (func_t* callback ) )
  (void ra:remove-seqblock-deleted-callback (func_t* callback ) )
  (void ra:mark-seqblock-available (int64_t seqblockid ) )
  (void ra:unmark-seqblock-available (int64_t seqblockid ) )
  (dynvec_t ra:get-seqblocknum-z-order (int seqtracknum ) )
  (dynvec_t ra:get-seqblock-z-order (int seqtracknum ) )
  (void ra:set-seqblock-z-order (dynvec_t zorder ) (int seqtracknum ) )
  (int64_t ra:get-seqblock-interior-start (int seqblocknum ) (int seqtracknum ) (bool use_gfx_if_possible false) )
  (int64_t ra:get-seqblock-interior-end (int seqblocknum ) (int seqtracknum ) (bool use_gfx_if_possible false) )
  (void ra:cut-selected-seqblocks )
  (void ra:paste-seqblocks (int seqtracknum -1) (int64_t time -1) )
  (void ra:copy-selected-seqblocks )
  (void ra:delete-selected-seqblocks )
  (dynvec_t ra:get-sequencer-tempos (int64_t start_time ) (int64_t end_time ) (bool include_all_tempos_needed_to_paint_graph true) )
  (dynvec_t ra:get-all-sequencer-tempos )
  (void ra:set-sequencer-tempos (dynvec_t tempos ) )
  (dynvec_t ra:get-sequencer-signatures (int64_t start_seqtime ) (int64_t end_seqtime ) )
  (dynvec_t ra:get-all-sequencer-signatures )
  (void ra:set-sequencer-signatures (dynvec_t signatures ) )
  (dyn_t ra:get-sequencer-timing )
  (void ra:set-sequencer-timing (dyn_t state ) )
  (dynvec_t ra:get-all-sequencer-markers )
  (void ra:set-sequencer-markers (dynvec_t markers ) )
  (bool ra:do-paint-vertical-markers-in-sequencer )
  (void ra:set-paint-vertical-markers-in-sequencer (bool doit ) )
  (void ra:jump-to-sequencer-mark (int marknum ) )
  (void ra:jump-prev-sequencer-mark )
  (void ra:jump-next-sequencer-mark )
  (bool ra:is-using-sequencer-timing )
  (void ra:set-using-sequencer-timing (bool use_sequencer ) (bool make_undo true) )
  (void ra:iterate-sequencer-time (int64_t start_time ) (int64_t end_time ) (const_char* grid_type ) (func_t* callback ) )
  (bool ra:show-bars-and-beats-sequencer-lane )
  (void ra:set-show-bars-and-beats-sequencer-lane (bool doit ) )
  (bool ra:show-time-sequencer-lane )
  (void ra:set-show-time-sequencer-lane (bool doit ) )
  (bool ra:show-tempos-sequencer-lane )
  (void ra:set-show-tempos-sequencer-lane (bool doit ) )
  (bool ra:show-signatures-sequencer-lane )
  (void ra:set-show-signatures-sequencer-lane (bool doit ) )
  (bool ra:show-markers-sequencer-lane )
  (void ra:set-show-markers-sequencer-lane (bool doit ) )
  (int ra:gui_get-system-fontheight )
  (void ra:gui_tool-tip (const_char* text ) )
  (const_char* ra:gui_mix-colors (const_char* color1 ) (const_char* color2 ) (float how_much_color1 ) )
  (const_char* ra:gui_set-alpha-for-color (const_char* color ) (float how_much_alpha ) )
  (const_char* ra:gui_make-color-lighter (const_char* color ) (float how_much ) )
  (const_char* ra:gui_make-color-darker (const_char* color ) (float how_much ) )
  (double ra:gui_color-distance (const_char* color1 ) (const_char* color2 ) )
  (float ra:gui_text-width (const_char* text ) (int64_t guinum -1) )
  (int64_t ra:gui_ui (filepath_t filename ) )
  (int ra:gui_num-open-guis )
  (void ra:gui_post-key-event (int64_t guinum ) (int qtkeynum ) (int64_t qtmodifiers ) (bool is_pressing ) )
  (int64_t ra:gui_random )
  (int64_t ra:gui_child (int64_t guinum ) (const_char* childname ) )
  (void ra:gui_set-name (int64_t guinum ) (const_char* guiname ) )
  (void ra:gui_add-realtime-callback (int64_t guinum ) (func_t* callback ) )
  (void ra:gui_add-callback (int64_t guinum ) (func_t* callback ) )
  (bool ra:gui_rerun-last-mouse-event )
  (void ra:gui_add-deleted-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_add-after-deleted-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_add-mouse-callback (int64_t guinum ) (func_t* func ) )
  (int ra:gui_get-curr-mouse-button (int64_t guinum ) )
  (void ra:gui_add-mouse-wheel-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_remove-mouse-wheel-callback (int64_t guinum ) )
  (void ra:gui_add-key-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_add-focus-in-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_add-double-click-callback (int64_t guinum ) (func_t* func ) )
  (bool ra:gui_is-double-clicking (int64_t guinum ) )
  (bool ra:gui_supports-callbacks (int64_t guinum ) )
  (void ra:gui_add-close-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_add-resize-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_add-paint-callback (int64_t guinum ) (func_t* func ) (bool paint_on_top false) )
  (void ra:gui_update-recursively (int64_t guinum ) )
  (void ra:gui_update (int64_t guinum ) (double x1 -1) (double y1 -1) (double x2 -1) (double y2 -1) )
  (void ra:gui_set-clip-rect (int64_t guinum ) (double x1 ) (double y1 ) (double x2 ) (double y2 ) )
  (void ra:gui_cancel-clip-rect (int64_t guinum ) )
  (void ra:gui_dont-autofill-background (int64_t guinum ) )
  (int64_t ra:gui_vertical-audio-meter (instrument_t instrument_id ) (dyn_t note_event_instrument_id g_dyn_minus_one) )
  (int64_t ra:gui_add-vertical-audio-meter (int64_t guinum ) (instrument_t instrument_id ) (double x1 ) (double y1 ) (double x2 ) (double y2 ) (dyn_t note_event_instrument_id g_dyn_minus_one) )
  (void ra:gui_set-vertical-audio-meter-clip-rect (int64_t vam ) (double x1 ) (double y1 ) (double x2 ) (double y2 ) )
  (bool ra:gui_remove-vertical-audio-meter (int64_t vam ) (bool throw_error_if_not_found true) )
  (int ra:gui_remove-all-vertical-audio-meters (int64_t guinum ) )
  (void ra:gui_add-audio-meter-peak-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_reset-audio-meter-peak (int64_t guinum ) )
  (int64_t ra:gui_widget (int width -1) (int height -1) )
  (int64_t ra:gui_popup (int width -1) (int height -1) )
  (int64_t ra:gui_button (const_char* text ) )
  (int64_t ra:gui_checkbox (const_char* text ) (bool is_checked ) (bool radium_style false) )
  (int64_t ra:gui_radiobutton (const_char* text ) (bool is_checked ) )
  (int64_t ra:gui_horizontal-int-slider (dyn_t textorfunc ) (int min ) (int curr ) (int max ) )
  (int64_t ra:gui_horizontal-slider (dyn_t textorfunc ) (double min ) (double curr ) (double max ) )
  (int64_t ra:gui_vertical-int-slider (dyn_t textorfunc ) (int min ) (int curr ) (int max ) )
  (int64_t ra:gui_vertical-slider (dyn_t textorfunc ) (double min ) (double curr ) (double max ) )
  (int64_t ra:gui_vertical-layout )
  (int64_t ra:gui_horizontal-layout )
  (int64_t ra:gui_table-layout (int num_columns ) )
  (int64_t ra:gui_flow-layout )
  (int64_t ra:gui_group (const_char* title ) )
  (int64_t ra:gui_scroll-area (bool scroll_horizontal true) (bool scroll_vertical true) (bool listen_to_mouse_wheel true) )
  (int64_t ra:gui_vertical-scroll (bool listen_to_mouse_wheel true) )
  (int64_t ra:gui_horizontal-scroll (bool listen_to_mouse_wheel true) )
  (int64_t ra:gui_line (const_char* content ) (const_char* textcolor "") )
  (int64_t ra:gui_text-edit (const_char* content ) (bool read_only false) )
  (int64_t ra:gui_ratio (dyn_t ratio ) (bool wheelMainlyChangesNumerator true) (bool wheelDecrasesDenominatorIfNumeratorIsOne true) )
  (int64_t ra:gui_text (const_char* text ) (const_char* color "") (bool align_top false) (bool align_left true) )
  (int64_t ra:gui_int-text (int min ) (int curr ) (int max ) )
  (int64_t ra:gui_float-text (double min ) (double curr ) (double max ) (int num_decimals 2) (double step_interval -1) )
  (int64_t ra:gui_web (const_char* url ) )
  (void ra:gui_set-url (int64_t gui ) (const_char* url ) )
  (bool ra:gui_web-can-show-manual )
  (void ra:open-external-web-browser (const_char* stringurl ) )
  (int64_t ra:gui_file-requester (const_char* header_text ) (filepath_t dir createIllegalFilepath()) (const_char* filetypename "") (const_char* postfixes "") (bool for_loading true) (const_char* default_suffix "") (bool several_files false) )
  (int64_t ra:gui_font-requester (const_char* fontdescr "") )
  (int64_t ra:gui_editor )
  (void ra:gui_editor-load-file (int64_t guinum ) (filepath_t filename ) )
  (void ra:gui_editor-set-file (int64_t guinum ) (filepath_t filename ) (bool load_if_exists true) )
  (void ra:gui_editor-save (int64_t guinum ) (filepath_t filename createIllegalFilepath()) )
  (void ra:gui_editor-find (int64_t guinum ) )
  (void ra:gui_editor-find-next (int64_t guinum ) )
  (void ra:gui_editor-add-text-changed-callback (int64_t guinum ) (func_t* callback ) )
  (int64_t ra:gui_bottom-bar (bool include_editor_elements ) (bool include_navigator ) )
  (int64_t ra:gui_tabs (int tab_pos 0) )
  (int64_t ra:gui_get-tab-bar (int64_t tabs_guinum ) )
  (void ra:gui_remove-tab (int64_t tabs_guinum ) (int pos ) )
  (int ra:gui_add-tab (int64_t tabs_guinum ) (const_char* name ) (int64_t tab_guinum ) (int pos -1) )
  (int ra:gui_current-tab (int64_t tabs_guinum ) )
  (void ra:gui_set-current-tab (int64_t tabs_guinum ) (int pos ) )
  (int ra:gui_get-tab-pos (int64_t tabs_guinum ) (int64_t tab_guinum ) )
  (int ra:gui_num-tabs (int64_t tabs_guinum ) )
  (const_char* ra:gui_tab-name (int64_t tabs_guinum ) (int pos -1) )
  (int64_t ra:gui_vertical-splitter (bool childrenCollappsible false) )
  (int64_t ra:gui_horizontal-splitter (bool childrenCollappsible false) )
  (int64_t ra:gui_get-splitter-handle (int64_t splitter_guinum ) (int pos ) )
  (dynvec_t ra:gui_get-splitter-sizes (int64_t splitter_guinum ) )
  (void ra:gui_set-splitter-sizes (int64_t splitter_guinum ) (dynvec_t splitter_sizes ) )
  (int64_t ra:gui_table (dynvec_t header_names ) )
  (int64_t ra:gui_add-table-gui-cell (int64_t table_guinum ) (int64_t cell_gui_num ) (int x ) (int y ) (bool enabled true) )
  (int64_t ra:gui_add-table-string-cell (int64_t table_guinum ) (const_char* string ) (int x ) (int y ) (bool enabled true) )
  (int64_t ra:gui_add-table-int-cell (int64_t table_guinum ) (int64_t num ) (int x ) (int y ) (bool enabled true) )
  (int64_t ra:gui_add-table-float-cell (int64_t table_guinum ) (double num ) (int x ) (int y ) (bool enabled true) )
  (void ra:gui_add-table-rows (int64_t table_guinum ) (int pos ) (int how_many ) )
  (int ra:gui_get-num-table-rows (int64_t table_guinum ) )
  (int ra:gui_curr-table-row (int64_t table_guinum ) )
  (int ra:gui_get-table-row-num (int64_t table_guinum ) (int64_t cell_guinum ) )
  (void ra:gui_enable-table-sorting (int64_t table_guinum ) (bool do_sort ) )
  (void ra:gui_sort-table-by (int64_t table_guinum ) (int x ) (bool sort_ascending ) )
  (void ra:gui_stretch-table (int64_t table_guinum ) (int x ) (bool do_stretch ) (int size ) )
  (const_char* ra:gui_class-name (int64_t guinum ) )
  (void ra:gui_set-window-title (int64_t guinum ) (const_char* value ) (bool name_is_base64 false) )
  (void ra:gui_set-tool-tip (int64_t guinum ) (const_char* value ) )
  (void ra:gui_set-text (int64_t guinum ) (const_char* value ) (const_char* color "") )
  (void ra:gui_set-value (int64_t guinum ) (dyn_t value ) )
  (void ra:gui_append-value (int64_t guinum ) (dyn_t value ) )
  (dyn_t ra:gui_get-value (int64_t guinum ) )
  (void ra:gui_add (int64_t parentnum ) (int64_t childnum ) (int x1_or_stretch -1) (int y1 -1) (int x2 -1) (int y2 -1) )
  (void ra:gui_replace (int64_t parentnum ) (int64_t oldchildnum ) (int64_t newchildnum ) )
  (bool ra:gui_is-visible (int64_t guinum ) )
  (void ra:gui_add-visibility-change-callback (int64_t guinum ) (func_t* func ) )
  (void ra:gui_show (int64_t guinum ) )
  (void ra:gui_hide (int64_t guinum ) )
  (void ra:gui_close (int64_t guinum ) )
  (bool ra:gui_is-open (int64_t guinum ) )
  (bool ra:gui_set-parent (int64_t guinum ) (int64_t parentgui ) )
  (bool ra:gui_remove-parent (int64_t guinum ) )
  (int64_t ra:gui_get-parent-window (int64_t guinum ) )
  (int64_t ra:gui_get-parent-gui (int64_t guinum ) )
  (bool ra:gui_set-as-window (int64_t guinum ) (int64_t parentgui ) )
  (void ra:gui_set-modal (int64_t guinum ) (bool set_modal ) )
  (bool ra:gui_is-modal (int64_t guinum ) )
  (void ra:gui_disable-updates (int64_t gui ) )
  (void ra:gui_enable-updates (int64_t gui ) )
  (int ra:gui_width (int64_t guinum ) )
  (int ra:gui_height (int64_t guinum ) )
  (int ra:gui_get-x (int64_t guinum ) )
  (int ra:gui_get-y (int64_t guinum ) )
  (int ra:gui_get-global-x (int64_t guinum ) )
  (int ra:gui_get-global-y (int64_t guinum ) )
  (float ra:gui_get-mouse-x (int64_t guinum ) )
  (float ra:gui_get-mouse-y (int64_t guinum ) )
  (void ra:gui_move-to-centre-of (int64_t guinum ) (int64_t window_to_move_in_centre_of ) )
  (void ra:gui_move-to-parent-centre (int64_t guinum ) )
  (void ra:gui_raise (int64_t guinum ) )
  (void ra:gui_activate (int64_t guinum ) )
  (void ra:gui_set-pos (int64_t guinum ) (int x ) (int y ) )
  (void ra:gui_set-size (int64_t guinum ) (int width ) (int height ) )
  (bool ra:gui_mouse-points-mainly-at (int64_t guinum ) )
  (void ra:gui_set-full-screen (int64_t guinum ) (bool enable true) )
  (bool ra:gui_is-full-screen (int64_t guinum ) )
  (void ra:gui_set-takes-keyboard-focus (int64_t guinum ) (bool take_it ) )
  (bool ra:gui_takes-keyboard-focus (int64_t guinum ) )
  (void ra:gui_set-background-color (int64_t guinum ) (const_char* color ) )
  (const_char* ra:gui_get-background-color (int64_t guinum ) )
  (const_char* ra:generate-new-color (float mix_background 1.0) )
  (const_char* ra:generate-new-block-color (float mix_background 1.0) )
  (const_char* ra:gui_get-font (int64_t guinum ) )
  (void ra:gui_set-font (int64_t guinum ) (const_char* font ) )
  (void ra:gui_set-style-sheet (int64_t guinum ) (const_char* stylesheet ) )
  (void ra:gui_set-style-sheet-recursively (int64_t guinum ) (const_char* stylesheet ) )
  (void ra:gui_set-layout-spacing (int64_t guinum ) (int spacing ) (int left ) (int top ) (int right ) (int bottom ) )
  (void ra:gui_add-layout-space (int64_t guinum ) (int width ) (int height ) (bool grow_horizontally true) (bool grow_vertically true) )
  (void ra:gui_set-layout-stretch (int64_t guinum ) (int64_t childguinum ) (int stretch ) )
  (void ra:gui_set-size-policy (int64_t guinum ) (bool grow_horizontally ) (bool grow_vertically ) )
  (void ra:gui_set-min-width (int64_t guinum ) (int minwidth ) )
  (void ra:gui_set-min-height (int64_t guinum ) (int minheight ) )
  (void ra:gui_set-max-width (int64_t guinum ) (int minwidth ) )
  (void ra:gui_set-max-height (int64_t guinum ) (int minheight ) )
  (void ra:gui_minimize-as-much-as-possible (int64_t guinum ) )
  (void ra:gui_set-enabled (int64_t guinum ) (bool is_enabled ) )
  (bool ra:gui_is-enabled (int64_t guinum ) )
  (void ra:gui_set-static-toplevel-widget (int64_t guinum ) (bool add true) )
  (int64_t ra:gui_get-main-x-splitter )
  (int64_t ra:gui_get-mixer-y-splitter )
  (int64_t ra:gui_get-editor-gui )
  (int64_t ra:gui_get-sequencer-gui )
  (int64_t ra:gui_get-sequencer-frame-gui )
  (int64_t ra:gui_get-instrument-gui )
  (int64_t ra:gui_get-main-mixer-gui )
  (int64_t ra:gui_get-main-mixer-strips-gui )
  (int64_t ra:gui_get-mixer-strips-gui-in-active-window )
  (double ra:gui_get-editor-distance-x (int64_t guinum ) )
  (double ra:gui_get-editor-distance-y (int64_t guinum ) )
  (const_char* ra:get-date-string (const_char* date_format "yyyy-MM-dd") )
  (const_char* ra:get-time-string (const_char* time_format "hh:mm:ss") )
  (const_char* ra:get-time-string-from-frames (int64_t num_frames ) )
  (const_char* ra:get-html-from-text (const_char* text ) )
  (const_char* ra:get-text-from-html (const_char* html ) )
  (void ra:gui_draw-line (int64_t guinum ) (const_char* color ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) (float width ) )
  (void ra:gui_draw-box (int64_t guinum ) (const_char* color ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) (float width ) (float round_x 5) (float round_y 5) )
  (void ra:gui_filled-box (int64_t guinum ) (const_char* color ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) (float round_x -1) (float round_y -1) (int gradient_type 3) (float how_much_gradient 0.10) )
  (void ra:gui_filled-polygon (int64_t guinum ) (const_char* color ) (dynvec_t points ) )
  (void ra:gui_draw-polygon (int64_t guinum ) (const_char* color ) (dynvec_t points ) (float width ) )
  (void ra:gui_draw-ellipse (int64_t guinum ) (const_char* color ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) (float width ) )
  (void ra:gui_filled-ellipse (int64_t guinum ) (const_char* color ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) )
  (bool ra:gui_draw-text (int64_t guinum ) (const_char* color ) (const_char* text ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) (bool wrap_lines true) (bool align_top false) (bool align_left false) (int rotate 0) (bool cut_text_to_fit true) (bool scale_font_size true) (bool text_is_base64 false) )
  (void ra:gui_set-paint-opacity (int64_t guinum ) (double opacity ) )
  (void ra:gui_draw-vertical-text (int64_t guinum ) (const_char* color ) (const_char* text ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) (bool wrap_lines true) (bool align_left false) (bool align_top false) )
  (void ra:gui_draw-svg (int64_t guinum ) (filepath_t svgfile ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) )
  (bool ra:gui_area-needs-painting (int64_t guinum ) (float x1 ) (float y1 ) (float x2 ) (float y2 ) )
  (void ra:gui_create-block-drag-icon (int64_t parent ) (int width ) (int height ) (float hotspot_x ) (float hotspot_y ) (int blocknum ) (func_t* paint_icon_callback ) )
  (void ra:gui_create-file-drag-icon (int64_t parent ) (int width ) (int height ) (float hotspot_x ) (float hotspot_y ) (filepath_t w_path ) (func_t* paint_icon_callback ) )
  (void ra:obtain-keyboard-focus (int64_t guinum -1) )
  (void ra:release-keyboard-focus )
  (bool ra:gui_has-keyboard-focus (int64_t guinum ) )
  (bool ra:gui_is-active-window (int64_t guinum ) )
  (float ra:gui_get-gfx-scale (float width_or_height ) (float downscale 1.0) )
  (void ra:inform-about-gui-being-a-mixer-strips (int64_t guinum ) )
  (int64_t ra:gui_create-mixer-strips (int num_rows -1) (dyn_t vert_ratio g_uninitialized_dyn) (dyn_t instrument_ids g_uninitialized_dyn) )
  (int ra:gui_get-num-rows-in-mixer-strips (int64_t guinum -1) )
  (void ra:gui_set-num-rows-in-mixer-strips (int num_rows ) (int64_t guinum -1) )
  (dyn_t ra:gui_get-vert-ratio-in-mixer-strips (int64_t guinum -1) )
  (void ra:gui_set-vert-ratio-in-mixer-strips (dyn_t vert_ratio ) (int64_t guinum -1) )
  (void ra:gui_reset-all-mixer-strips )
  (dyn_t ra:gui_get-mixer-strips-configuration (int64_t guinum ) )
  (void ra:gui_set-mixer-strips-configuration (int64_t guinum ) (dyn_t configuration ) )
  (int64_t ra:show-mixer-strips (int num_rows 1) )
  (int64_t ra:show-mixer-strips2 (int num_rows 1) (dyn_t instrument_ids g_uninitialized_dyn) )
  (int64_t ra:gui_create-single-mixer-strip (instrument_t instrument_id ) (int width 100) (int height 600) )
  (float ra:get-curr-mixer-slot-x )
  (float ra:get-curr-mixer-slot-y )
  (bool ra:triangles-intersects (float a_x1 ) (float a_y1 ) (float a_x2 ) (float a_y2 ) (float a_x3 ) (float a_y3 ) (float b_x1 ) (float b_y1 ) (float b_x2 ) (float b_y2 ) (float b_x3 ) (float b_y3 ) (bool allowReversed true) (bool onBoundary false) )
))
